/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericRangeValidator<T extends Comparable<T>>
extends ModelPropertyValidator<Value<T>> {
    private final T min;
    private final T max;

    public NumericRangeValidator(T minValue, T maxValue) {
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public IStatus validate(Value<T> value) {
        Comparable val = (Comparable)value.getContent(true);
        if (val != null) {
            ValueProperty property = value.getProperty();
            if (this.min != null && val.compareTo(this.min) < 0) {
                String msg = NLS.bind((String)Resources.smallerThanMinimumMessage, (Object)val, (Object)this.normalizeForDisplay(property, this.min));
                return this.createErrorStatus(msg);
            }
            if (this.max != null && val.compareTo(this.max) > 0) {
                String msg = NLS.bind((String)Resources.largerThanMaxiumMessage, (Object)val, (Object)this.normalizeForDisplay(property, this.max));
                return this.createErrorStatus(msg);
            }
        }
        return Status.OK_STATUS;
    }

    private String normalizeForDisplay(ValueProperty property, T value) {
        String result = property.encodeKeywords(value.toString());
        ValueKeyword keyword = property.getKeyword(result);
        if (keyword != null) {
            result = keyword.toDisplayString();
        }
        return result;
    }

    private static final class Resources
    extends NLS {
        public static String smallerThanMinimumMessage;
        public static String largerThanMaxiumMessage;

        static {
            Resources.initializeMessages((String)NumericRangeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

