/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.ValidFileExtensions;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathValueValidator
extends ModelPropertyValidator<Value<IPath>> {
    protected final boolean resourceMustExist;
    protected final FileSystemResourceType validResourceType;
    private final String[] validFileExtensions;

    public PathValueValidator(ValueProperty property) {
        this.resourceMustExist = property.hasAnnotation(MustExist.class);
        ValidFileSystemResourceType validResourceTypeAnnotation = property.getAnnotation(ValidFileSystemResourceType.class);
        this.validResourceType = validResourceTypeAnnotation != null ? validResourceTypeAnnotation.value() : null;
        ValidFileExtensions validFileExtensionsAnnotation = property.getAnnotation(ValidFileExtensions.class);
        this.validFileExtensions = validFileExtensionsAnnotation != null ? validFileExtensionsAnnotation.value() : null;
    }

    protected final IStatus validateExtensions(IPath path) {
        String fileName = path.lastSegment();
        if (fileName != null) {
            return PathValueValidator.validateExtensions(fileName, this.validFileExtensions);
        }
        return Status.OK_STATUS;
    }

    public static final IStatus validateExtensions(String fileName, ValueProperty property) {
        ValidFileExtensions validFileExtensionsAnnotation = property.getAnnotation(ValidFileExtensions.class);
        if (validFileExtensionsAnnotation != null) {
            return PathValueValidator.validateExtensions(fileName, validFileExtensionsAnnotation.value());
        }
        return Status.OK_STATUS;
    }

    public static final IStatus validateExtensions(String fileName, String[] validFileExtensions) {
        if (validFileExtensions != null && validFileExtensions.length > 0) {
            String trimmedFileName = fileName.trim();
            int lastdot = trimmedFileName.lastIndexOf(46);
            String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
            boolean match = false;
            if (extension != null && extension.length() != 0) {
                String[] stringArray = validFileExtensions;
                int n = validFileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (extension.equalsIgnoreCase(ext)) {
                        match = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!match) {
                String message;
                if (validFileExtensions.length == 1) {
                    message = NLS.bind((String)Resources.invalidFileExtensionOne, (Object)trimmedFileName, (Object)validFileExtensions[0]);
                } else if (validFileExtensions.length == 2) {
                    message = NLS.bind((String)Resources.invalidFileExtensionOne, (Object[])new String[]{trimmedFileName, validFileExtensions[0], validFileExtensions[1]});
                } else {
                    StringBuilder buf = new StringBuilder();
                    String[] stringArray = validFileExtensions;
                    int n = validFileExtensions.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String ext = stringArray[n3];
                        if (buf.length() != 0) {
                            buf.append(", ");
                        }
                        buf.append(ext);
                        ++n3;
                    }
                    message = NLS.bind((String)Resources.invalidFileExtensionMultiple, (Object)trimmedFileName, (Object)buf.toString());
                }
                return new Status(4, "org.eclipse.sapphire.modeling", message);
            }
        }
        return Status.OK_STATUS;
    }

    protected static final class Resources
    extends NLS {
        public static String folderMustExist;
        public static String fileMustExist;
        public static String resourceMustExist;
        public static String pathIsNotFile;
        public static String pathIsNotFolder;
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages((String)PathValueValidator.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

