/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPath {
    private final List<Segment> segments = new ArrayList<Segment>();
    private final List<Segment> segmentsReadOnly = Collections.unmodifiableList(this.segments);

    public XmlPath(List<Segment> segments) {
        this.segments.addAll(segments);
    }

    public XmlPath(String path) {
        this(path, null);
    }

    public XmlPath(String path, XmlNamespaceResolver namespaceResolver) {
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() != 0) {
                String prefix = "";
                String localName = null;
                boolean isAttribute = false;
                boolean isComment = false;
                if (part.startsWith("@")) {
                    localName = part.substring(1);
                    isAttribute = true;
                } else if (part.startsWith("%")) {
                    localName = part.substring(1);
                    isComment = true;
                } else {
                    int colon = part.indexOf(58);
                    if (colon == -1) {
                        localName = part;
                    } else {
                        prefix = part.substring(0, colon);
                        localName = part.substring(colon + 1);
                    }
                }
                String namespace = null;
                if (prefix.length() > 0 && namespaceResolver != null) {
                    namespace = namespaceResolver.resolve(prefix);
                }
                this.segments.add(new Segment(new QName(namespace, localName, prefix), isAttribute, isComment));
            }
            ++n2;
        }
    }

    public List<Segment> getSegments() {
        return this.segmentsReadOnly;
    }

    public Segment getSegment(int index) {
        return this.segments.get(index);
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public static final class Segment {
        private final QName qname;
        private final boolean isAttribute;
        private final boolean isComment;

        public Segment(QName qname, boolean isAttribute, boolean isComment) {
            this.qname = qname;
            this.isAttribute = isAttribute;
            this.isComment = isComment;
        }

        public QName getQualifiedName() {
            return this.qname;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }

        public boolean isComment() {
            return this.isComment;
        }
    }
}

