/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.wst.dtd.core.internal.contentmodel.CMNodeImpl;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDOccurrenceType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDParser {
    public static final void parse(String schemaLocation, XmlDocumentSchema schema, Map<String, XmlContentModel> contentModels, Map<String, XmlElementDefinition> topLevelElements) {
        CMDocument doc = ContentModelManager.getInstance().createCMDocument(schemaLocation, "dtd");
        CMNamedNodeMap elements = doc.getElements();
        for (Object obj : elements) {
            Object key;
            if (!(obj instanceof CMNodeImpl) || !((key = ((CMNodeImpl)obj).getKey()) instanceof DTDElement)) continue;
            DTDElement element = (DTDElement)key;
            XmlContentModel contentModel = DTDParser.parseElement(schema, element);
            if (contentModel != null) {
                contentModels.put(element.getName(), contentModel);
            }
            QName qname = new QName(element.getName());
            XmlElementDefinition elem = new XmlElementDefinition(schema, qname, qname, 1, 1);
            topLevelElements.put(element.getName(), elem);
        }
    }

    private static final XmlContentModel parseElement(XmlDocumentSchema schema, DTDElement element) {
        ArrayList<XmlContentModel> nestedContentModels = new ArrayList<XmlContentModel>();
        if (element.getContent() instanceof DTDElementReferenceContent) {
            XmlElementDefinition def = DTDParser.createXmlElementDefinition(schema, (DTDElementReferenceContent)element.getContent());
            if (def != null) {
                nestedContentModels.add(def);
            }
        } else {
            TreeIterator i = element.getContent().eAllContents();
            while (i.hasNext()) {
                DTDElementReferenceContent referenceContent;
                XmlElementDefinition def;
                EObject childEObject = (EObject)i.next();
                if (!(childEObject instanceof DTDElementReferenceContent) || (def = DTDParser.createXmlElementDefinition(schema, referenceContent = (DTDElementReferenceContent)childEObject)) == null) continue;
                nestedContentModels.add(def);
            }
        }
        if (nestedContentModels.size() > 0) {
            return new XmlSequenceGroup(schema, 1, 1, nestedContentModels);
        }
        return null;
    }

    private static final XmlElementDefinition createXmlElementDefinition(XmlDocumentSchema schema, DTDElementReferenceContent referenceContent) {
        String name = referenceContent.getContentName();
        DTDOccurrenceType occurrence = referenceContent.getOccurrence();
        int minOccur = 1;
        int maxOccur = 1;
        switch (occurrence.getValue()) {
            case 49: {
                minOccur = 1;
                maxOccur = 1;
                break;
            }
            case 63: {
                minOccur = 0;
                maxOccur = 1;
                break;
            }
            case 43: {
                minOccur = 1;
                maxOccur = Integer.MAX_VALUE;
                break;
            }
            case 42: {
                minOccur = 0;
                maxOccur = Integer.MAX_VALUE;
            }
        }
        QName qname = new QName(name);
        return new XmlElementDefinition(schema, qname, qname, minOccur, maxOccur);
    }
}

