/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementDefinition
extends XmlContentModel {
    private QName elementName;
    private QName contentModelName;

    public XmlElementDefinition(XmlDocumentSchema schema, QName elementName, QName contentModelName, int minOccur, int maxOccur) {
        super(schema, minOccur, maxOccur);
        this.elementName = elementName;
        this.contentModelName = contentModelName;
    }

    public QName getName() {
        return this.elementName;
    }

    public QName getContentModelName() {
        return this.contentModelName;
    }

    public XmlContentModel getContentModel() {
        QName contentModelName = this.getContentModelName();
        if (contentModelName == null) {
            return null;
        }
        String namespace = contentModelName.getNamespaceURI();
        String localName = contentModelName.getLocalPart();
        if (namespace.equals(this.schema.getNamespace())) {
            return this.schema.getContentModel(localName);
        }
        String importedSchemaLocation = this.schema.getSchemaLocation(namespace);
        XmlDocumentSchema importedSchema = XmlDocumentSchemasCache.getSchema(importedSchemaLocation);
        return importedSchema.getContentModel(localName);
    }

    public XmlContentModel findChildElementContentModel(QName childElementName) {
        if (this.elementName.equals(childElementName)) {
            return this.getContentModel();
        }
        return null;
    }

    protected XmlContentModel.InsertionPosition findInsertionPosition(NodeList nodeList, int nodeListLength, QName qname, XmlContentModel.Position position) {
        int elementsConsumed = 0;
        while (position.listIndex < nodeListLength) {
            Node node = nodeList.item(position.listIndex);
            if (node.getNodeType() != 1) {
                ++position.listIndex;
                continue;
            }
            QName eln = new QName(node.getNamespaceURI(), node.getLocalName());
            if (!eln.equals(this.elementName)) break;
            ++elementsConsumed;
            ++position.listIndex;
        }
        XmlContentModel.InsertionPosition result = new XmlContentModel.InsertionPosition();
        if (this.elementName.equals(qname)) {
            result.listIndex = position.listIndex;
            int elementCountAfterAdd = elementsConsumed + 1;
            result.grade = this.maxOccur != -1 && elementCountAfterAdd > this.maxOccur ? 1 : (elementCountAfterAdd <= this.minOccur ? 4 : 3);
        }
        return result;
    }

    protected void toString(StringBuilder buf, String indent) {
        buf.append(indent);
        buf.append("element [");
        buf.append(this.minOccur);
        buf.append(':');
        buf.append(this.maxOccur);
        buf.append("]\n");
        buf.append(indent);
        buf.append("{\n");
        buf.append(indent);
        buf.append("    name = ");
        buf.append(this.elementName);
        buf.append('\n');
        QName contentModelName = this.getContentModelName();
        if (contentModelName != null) {
            buf.append(indent);
            buf.append("    type = ");
            buf.append(contentModelName);
            buf.append('\n');
        }
        buf.append(indent);
        buf.append('}');
    }
}

