/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePropertyEditorActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;

public final class PrefixActionHandlerForValue
extends SapphirePropertyEditorActionHandler {
    private String prefix;
    private ModelPropertyListener listener;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.prefix = String.valueOf(def.getParam("prefix")) + " ";
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                PrefixActionHandlerForValue.this.refreshEnabledState();
                PrefixActionHandlerForValue.this.refreshCheckedState();
            }
        };
        this.getModelElement().addListener(this.listener, this.getProperty().getName());
        this.refreshEnabledState();
        this.refreshCheckedState();
    }

    public ValueProperty getProperty() {
        return (ValueProperty)super.getProperty();
    }

    protected Object run(SapphireRenderingContext context) {
        IModelElement element = this.getModelElement();
        ValueProperty property = this.getProperty();
        String oldValue = element.read(property).getText();
        Object newValue = this.isChecked() ? String.valueOf(this.prefix) + oldValue : (oldValue.startsWith(this.prefix) ? (oldValue.length() == this.prefix.length() ? null : oldValue.substring(this.prefix.length())) : oldValue);
        element.write(property, newValue);
        return null;
    }

    private void refreshEnabledState() {
        String value = this.getModelElement().read(this.getProperty()).getText();
        this.setEnabled(value != null);
    }

    private void refreshCheckedState() {
        String value = this.getModelElement().read(this.getProperty()).getText();
        this.setChecked(value != null && value.startsWith(this.prefix));
    }

    public void dispose() {
        super.dispose();
        this.getModelElement().removeListener(this.listener, this.getProperty().getName());
    }
}

