/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.xml.schema.XmlChoiceGroup;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class FindInsertionPositionTests
extends TestCase {
    private FindInsertionPositionTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("FindInsertPositionTests");
        suite.addTest((Test)new FindInsertionPositionTests("test_1A"));
        suite.addTest((Test)new FindInsertionPositionTests("test_1B"));
        suite.addTest((Test)new FindInsertionPositionTests("test_1C"));
        suite.addTest((Test)new FindInsertionPositionTests("test_1D"));
        suite.addTest((Test)new FindInsertionPositionTests("test_1E"));
        suite.addTest((Test)new FindInsertionPositionTests("test_2A"));
        suite.addTest((Test)new FindInsertionPositionTests("test_2B"));
        suite.addTest((Test)new FindInsertionPositionTests("test_2C"));
        suite.addTest((Test)new FindInsertionPositionTests("test_3A"));
        suite.addTest((Test)new FindInsertionPositionTests("test_3B"));
        suite.addTest((Test)new FindInsertionPositionTests("test_3C"));
        suite.addTest((Test)new FindInsertionPositionTests("test_3D"));
        suite.addTest((Test)new FindInsertionPositionTests("test_4A"));
        suite.addTest((Test)new FindInsertionPositionTests("test_4B"));
        suite.addTest((Test)new FindInsertionPositionTests("test_4C"));
        suite.addTest((Test)new FindInsertionPositionTests("test_5A"));
        suite.addTest((Test)new FindInsertionPositionTests("test_5B"));
        suite.addTest((Test)new FindInsertionPositionTests("test_5C"));
        return suite;
    }

    public void test_1A() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 0, -1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("C", 0, -1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root></root>", "A", "<root><A/></root>");
    }

    public void test_1B() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 0, -1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("C", 0, -1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root></root>", "B", "<root><B/></root>");
    }

    public void test_1C() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 0, -1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("C", 0, -1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><B/><C/><C/></root>", "A", "<root><A/><A/><A/><B/><B/><C/><C/></root>");
    }

    public void test_1D() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 0, -1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("C", 0, -1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><B/><C/><C/></root>", "B", "<root><A/><A/><B/><B/><B/><C/><C/></root>");
    }

    public void test_1E() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 0, -1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("C", 0, -1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><B/><C/><C/></root>", "C", "<root><A/><A/><B/><B/><C/><C/><C/></root>");
    }

    public void test_2A() throws Exception {
        XmlChoiceGroup XmlContentModel2 = FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><A/><C/><B/></root>", "A", "<root><A/><A/><B/><A/><C/><B/><A/></root>");
    }

    public void test_2B() throws Exception {
        XmlChoiceGroup XmlContentModel2 = FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><A/><C/><B/></root>", "B", "<root><A/><A/><B/><A/><C/><B/><B/></root>");
    }

    public void test_2C() throws Exception {
        XmlChoiceGroup XmlContentModel2 = FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><A/><B/><A/><C/><B/></root>", "C", "<root><A/><A/><B/><A/><C/><B/><C/></root>");
    }

    public void test_3A() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.element("D", 0, -1)}), FindInsertionPositionTests.element("E", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>", "B", "<root>\n  <A/>\n  <B/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>");
    }

    public void test_3B() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.element("D", 0, -1)}), FindInsertionPositionTests.element("E", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>", "C", "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <C/>\n  <E/>\n</root>");
    }

    public void test_3C() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.element("D", 0, -1)}), FindInsertionPositionTests.element("E", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>", "D", "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>");
    }

    public void test_3D() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.element("D", 0, -1)}), FindInsertionPositionTests.element("E", 1, 1)});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n</root>", "E", "<root>\n  <A/>\n  <B/>\n  <B/>\n  <C/>\n  <D/>\n  <D/>\n  <D/>\n  <C/>\n  <E/>\n  <E/>\n</root>");
    }

    public void test_4A() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.sequence(1, -1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><C/></root>", "B", "<root><A/><C/><B/></root>");
    }

    public void test_4B() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.sequence(1, -1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><C/><D/><B/><B/><E/></root>", "B", "<root><A/><B/><C/><D/><B/><B/><E/></root>");
    }

    public void test_4C() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("B", 1, 1), FindInsertionPositionTests.element("C", 1, 1), FindInsertionPositionTests.sequence(1, -1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><B/><C/><D/><B/><B/><E/></root>", "B", "<root><A/><B/><C/><D/><B/><B/><B/><E/></root>");
    }

    public void test_5A() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("X", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("C", 1, 1)}), FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("D", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><B/><D/><C/></root>", "X", "<root><A/><X/><B/><D/><C/></root>");
    }

    public void test_5B() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("X", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("C", 1, 1)}), FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("D", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><X/><B/><D/><C/></root>", "X", "<root><A/><X/><B/><D/><X/><C/></root>");
    }

    public void test_5C() throws Exception {
        XmlSequenceGroup XmlContentModel2 = FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("A", 1, 1), FindInsertionPositionTests.element("X", 1, 1), FindInsertionPositionTests.element("B", 0, -1), FindInsertionPositionTests.choice(0, -1, new XmlContentModel[]{FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("D", 1, 1), FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("C", 1, 1)}), FindInsertionPositionTests.sequence(1, 1, new XmlContentModel[]{FindInsertionPositionTests.element("X", 0, 1), FindInsertionPositionTests.element("D", 0, -1), FindInsertionPositionTests.element("E", 1, 1)})})});
        FindInsertionPositionTests.test((XmlContentModel)XmlContentModel2, "<root><A/><X/><B/><D/><E/></root>", "X", "<root><A/><X/><B/><X/><D/><E/></root>");
    }

    private static void test(XmlContentModel XmlContentModel2, String initialContent, String elementNameToInsert, String expectedContent) throws Exception {
        Element root = FindInsertionPositionTests.parse(initialContent);
        NodeList nodeList = root.getChildNodes();
        int position = XmlContentModel2.findInsertionPosition(nodeList, new QName(elementNameToInsert));
        Element elementToInsert = root.getOwnerDocument().createElementNS(null, elementNameToInsert);
        if (position == -1) {
            root.appendChild(elementToInsert);
        } else {
            Node nodeAtPosition = nodeList.item(position);
            root.insertBefore(elementToInsert, nodeAtPosition);
        }
        Element expectedContentRoot = FindInsertionPositionTests.parse(expectedContent);
        if (!FindInsertionPositionTests.equal(nodeList, expectedContentRoot.getChildNodes())) {
            StringBuilder buf = new StringBuilder();
            buf.append("=== actual ===\n");
            buf.append(FindInsertionPositionTests.toString(root.getOwnerDocument()));
            buf.append("\n=== expected ===\n");
            buf.append(expectedContent);
            FindInsertionPositionTests.assertTrue((String)buf.toString(), (boolean)false);
        }
    }

    private static XmlChoiceGroup choice(int minOccur, int maxOccur, XmlContentModel ... list) {
        return new XmlChoiceGroup(null, minOccur, maxOccur, list);
    }

    private static XmlSequenceGroup sequence(int minOccur, int maxOccur, XmlContentModel ... list) {
        return new XmlSequenceGroup(null, minOccur, maxOccur, list);
    }

    private static XmlElementDefinition element(String name, int minOccur, int maxOccur) {
        return new XmlElementDefinition(null, new QName(name), null, minOccur, maxOccur);
    }

    private static Element parse(String content) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder docbuilder = factory.newDocumentBuilder();
        Document doc = docbuilder.parse(new InputSource(new StringReader(content)));
        return doc.getDocumentElement();
    }

    private static boolean equal(NodeList xList, NodeList yList) {
        int x = 0;
        int y = 0;
        int xLen = xList.getLength();
        int yLen = yList.getLength();
        while (x < xLen && y < yLen) {
            int i = x;
            while (i < xLen) {
                if (xList.item(i).getNodeType() == 1) break;
                ++x;
                ++i;
            }
            i = y;
            while (i < yLen) {
                if (yList.item(i).getNodeType() == 1) break;
                ++y;
                ++i;
            }
            if (x >= xLen || y >= yLen) continue;
            Node xnode = xList.item(x);
            Node ynode = yList.item(y);
            if (xnode.getLocalName().equals(ynode.getLocalName())) {
                ++x;
                ++y;
                continue;
            }
            return false;
        }
        int i = x;
        while (i < xLen) {
            if (xList.item(i).getNodeType() == 1) {
                return false;
            }
            ++i;
        }
        i = y;
        while (i < yLen) {
            if (yList.item(i).getNodeType() == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String toString(Document doc) throws Exception {
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
        return sw.toString();
    }
}

