/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0001;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0001.ITestXmlXsd0001ModelRoot;

public final class TestXmlXsd0001
extends TestCase {
    private TestXmlXsd0001(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlXsd001");
        suite.addTest((Test)new TestXmlXsd0001("testSchemaParsing"));
        suite.addTest((Test)new TestXmlXsd0001("testInsertOrder"));
        return suite;
    }

    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)"http://www.eclipse.org/sapphire/tests/xml/xsd/0001", null);
        XmlElementDefinition rootElementDef = schema.getElement("root");
        XmlSequenceGroup rootContentModel = (XmlSequenceGroup)rootElementDef.getContentModel();
        List nestedContent = rootContentModel.getNestedContent();
        TestXmlXsd0001.assertEquals((int)4, (int)nestedContent.size());
        TestXmlXsd0001.assertEquals((String)"aaa", (String)((XmlElementDefinition)nestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0001.assertEquals((String)"bbb", (String)((XmlElementDefinition)nestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0001.assertEquals((String)"ccc", (String)((XmlElementDefinition)nestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0001.assertEquals((String)"ddd", (String)((XmlElementDefinition)nestedContent.get(3)).getName().getLocalPart());
    }

    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        ITestXmlXsd0001ModelRoot model = (ITestXmlXsd0001ModelRoot)ITestXmlXsd0001ModelRoot.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        model.setDdd("ddd");
        model.setCcc("ccc");
        model.setBbb("bbb");
        model.setAaa("aaa");
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlXsd0001.assertEqualsIgnoreNewLineDiffs(this.loadResource("0001.txt"), result);
    }

    private InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    private String loadResource(String name) throws Exception {
        String string;
        InputStream in = this.loadResourceAsStream(name);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    private static void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        TestXmlXsd0001.assertEquals((String)expected.replace("\r", ""), (String)actual.replace("\r", ""));
    }
}

