/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.doc.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.sdk.extensibility.IExtensionSummaryExportOp;
import org.eclipse.sapphire.sdk.extensibility.IExtensionSummarySectionColumnDef;
import org.eclipse.sapphire.sdk.extensibility.IExtensionSummarySectionDef;
import org.eclipse.sapphire.sdk.extensibility.IFunctionDef;
import org.eclipse.sapphire.sdk.extensibility.ISapphireExtensionDef;
import org.eclipse.sapphire.ui.IExportModelDocumentationOp;
import org.eclipse.sapphire.ui.def.ISapphireActionDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFilterDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicContentProducer
implements IHelpContentProducer {
    private List<ISapphireExtensionDef> extensions;

    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        String content = null;
        if (pluginID.equals("org.eclipse.sapphire.doc")) {
            IExtensionSummaryExportOp op;
            if (href.equals("html/extensions/existing.html")) {
                op = (IExtensionSummaryExportOp)IExtensionSummaryExportOp.TYPE.instantiate();
                op.setDocumentBodyTitle("Sapphire Extensions");
                content = op.execute(this.getExtensions(), (IProgressMonitor)new NullProgressMonitor());
            }
            if (href.equals("html/el/index.html")) {
                op = (IExtensionSummaryExportOp)IExtensionSummaryExportOp.TYPE.instantiate();
                op.setCreateFinishedDocument(Boolean.valueOf(false));
                IExtensionSummarySectionDef section = (IExtensionSummarySectionDef)op.getSections().addNewElement();
                section.setExtensionType(ISapphireExtensionDef.PROP_FUNCTIONS.getName());
                section.setIncludeSectionHeader(Boolean.valueOf(false));
                IExtensionSummarySectionColumnDef nameColumn = (IExtensionSummarySectionColumnDef)section.getColumns().addNewElement();
                nameColumn.setName(IFunctionDef.PROP_NAME.getName());
                IExtensionSummarySectionColumnDef descColumn = (IExtensionSummarySectionColumnDef)section.getColumns().addNewElement();
                descColumn.setName(IFunctionDef.PROP_DESCRIPTION.getName());
                String functions = op.execute(this.getExtensions(), (IProgressMonitor)new NullProgressMonitor());
                content = DynamicContentProducer.loadResource("html/el/index.html");
                content = content.replace("##functions##", functions);
            } else if (href.equals("html/actions/index.html")) {
                content = DynamicContentProducer.loadResource("html/actions/index.html");
                String docAction = DynamicContentProducer.exportModelDocumentation(ISapphireActionDef.TYPE);
                content = content.replace("##action-details##", docAction);
                String docActionHandler = DynamicContentProducer.exportModelDocumentation(ISapphireActionHandlerDef.TYPE);
                content = content.replace("##action-handler-details##", docActionHandler);
                String docActionHandlerFactory = DynamicContentProducer.exportModelDocumentation(ISapphireActionHandlerFactoryDef.TYPE);
                content = content.replace("##action-handler-factory-details##", docActionHandlerFactory);
                String docActionHandlerFilter = DynamicContentProducer.exportModelDocumentation(ISapphireActionHandlerFilterDef.TYPE);
                content = content.replace("##action-handler-filter-details##", docActionHandlerFilter);
            }
        }
        if (content != null) {
            return new ByteArrayInputStream(content.getBytes());
        }
        return null;
    }

    private static String exportModelDocumentation(ModelElementType type) {
        IExportModelDocumentationOp op = (IExportModelDocumentationOp)IExportModelDocumentationOp.TYPE.instantiate();
        op.setCreateFinishedDocument(Boolean.valueOf(false));
        return op.execute(type, (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadResource(String name) {
        String string;
        InputStream in = DynamicContentProducer.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (true) {
                if (i == -1) {
                    string = buf.toString();
                    break;
                }
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    private synchronized List<ISapphireExtensionDef> getExtensions() {
        if (this.extensions == null) {
            ArrayList<ISapphireExtensionDef> list = new ArrayList<ISapphireExtensionDef>();
            for (ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                try {
                    XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new UrlResourceStore(handle.extension()));
                    RootXmlResource resource = new RootXmlResource(store);
                    ISapphireExtensionDef extension = (ISapphireExtensionDef)ISapphireExtensionDef.TYPE.instantiate((Resource)resource);
                    list.add(extension);
                }
                catch (ResourceStoreException e) {
                    SapphireUiFrameworkPlugin.log((Throwable)e);
                }
            }
            this.extensions = Collections.unmodifiableList(list);
        }
        return this.extensions;
    }
}

