/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

public final class StandardXmlValueBindingImpl
extends XmlValueBindingImpl {
    private XmlPath path;
    private boolean treatExistanceAsValue;
    private String valueWhenPresent;
    private String valueWhenNotPresent;
    private boolean removeNodeOnSetIfNull;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        try {
            XmlNamespaceResolver xmlNamespaceResolver = this.resource().getXmlNamespaceResolver();
            XmlBinding genericBindingAnnotation = (XmlBinding)property.getAnnotation(XmlBinding.class);
            if (genericBindingAnnotation != null) {
                this.path = new XmlPath(genericBindingAnnotation.path(), xmlNamespaceResolver);
                this.removeNodeOnSetIfNull = true;
            } else {
                XmlValueBinding bindingAnnotation = (XmlValueBinding)property.getAnnotation(XmlValueBinding.class);
                if (bindingAnnotation != null) {
                    this.path = new XmlPath(bindingAnnotation.path(), xmlNamespaceResolver);
                    this.removeNodeOnSetIfNull = bindingAnnotation.removeNodeOnSetIfNull();
                    if (bindingAnnotation.mapExistanceToValue().length() > 0) {
                        this.treatExistanceAsValue = true;
                        String directive = bindingAnnotation.mapExistanceToValue();
                        StringBuilder buf = new StringBuilder();
                        boolean escapeNextChar = false;
                        int separatorCount = 0;
                        int i = 0;
                        int n = directive.length();
                        while (i < n) {
                            char ch = directive.charAt(i);
                            if (escapeNextChar) {
                                buf.append(ch);
                                escapeNextChar = false;
                            } else if (ch == '\\') {
                                escapeNextChar = true;
                            } else if (ch == ';') {
                                ++separatorCount;
                                this.valueWhenPresent = buf.toString();
                                buf = new StringBuilder();
                            } else {
                                buf.append(ch);
                            }
                            ++i;
                        }
                        if (separatorCount == 0) {
                            this.valueWhenPresent = buf.toString();
                        } else {
                            this.valueWhenNotPresent = buf.toString();
                        }
                    }
                } else {
                    this.path = new XmlPath(property.getName(), xmlNamespaceResolver);
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failure, (Object[])new Object[]{element.getModelElementType().getSimpleName(), property.getName(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    public String read() {
        String value = null;
        XmlElement element = this.xml(false);
        if (element != null) {
            if (this.treatExistanceAsValue) {
                boolean exists = element.getChildNode(this.path, false) != null;
                value = exists ? this.valueWhenPresent : this.valueWhenNotPresent;
            } else {
                value = this.path == null ? element.getText() : element.getChildNodeText(this.path);
            }
        }
        return value;
    }

    public void write(String value) {
        if (this.treatExistanceAsValue) {
            boolean nodeShouldBePresent = this.valueWhenPresent.equals(value);
            if (nodeShouldBePresent) {
                this.xml(true).getChildNode(this.path, true);
            } else {
                XmlElement element = this.xml(false);
                if (element != null) {
                    element.removeChildNode(this.path);
                }
            }
        } else if (this.path == null) {
            this.xml(true).setText(value);
        } else {
            this.xml(true).setChildNodeText(this.path, value, this.removeNodeOnSetIfNull);
        }
    }

    public XmlNode getXmlNode() {
        XmlElement element = this.xml(false);
        if (element != null) {
            return element.getChildNode(this.path, false);
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String failure;

        static {
            Resources.initializeMessages((String)StandardXmlValueBindingImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

