/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlNode {
    private final XmlResourceStore store;
    private final XmlElement parent;
    private final Node domNode;
    private List<Listener> listeners;

    public XmlNode(XmlResourceStore store, XmlElement parent, Node domNode) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (domNode == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.parent = parent;
        this.domNode = domNode;
    }

    public final XmlResourceStore getResourceStore() {
        return this.store;
    }

    public final XmlElement getParent() {
        return this.parent;
    }

    public Node getDomNode() {
        return this.domNode;
    }

    public final void validateEdit() throws ValidateEditException {
        this.store.validateEdit();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XmlNode) {
            return this.domNode == ((XmlNode)obj).domNode;
        }
        return false;
    }

    public final int hashCode() {
        return this.domNode.hashCode();
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public final String toString() {
        try {
            StringWriter sw = new StringWriter();
            DOMSource source = new DOMSource(this.domNode);
            StreamResult result = new StreamResult(sw);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    public final void format() {
        this.validateEdit();
        this.removeFormatting();
        int depth = 0;
        if (this.domNode.getParentNode() != null) {
            Node n = this.domNode.getParentNode();
            while (n.getNodeType() == 1) {
                ++depth;
                n = n.getParentNode();
            }
        }
        this.format(depth);
    }

    private void format(int depth) {
        StringBuilder buf = new StringBuilder();
        buf.append('\n');
        int i = 0;
        while (i < depth) {
            buf.append("    ");
            ++i;
        }
        String formatting = buf.toString();
        Document document = this.domNode.getOwnerDocument();
        Node parent = this.domNode.getParentNode();
        if (parent.getNodeType() == 1 || parent.getNodeType() == 9) {
            Text textBeforeOpeningTag = document.createTextNode(formatting);
            parent.insertBefore(textBeforeOpeningTag, this.domNode);
        }
        if (this.domNode.getNodeType() == 1 && this.domNode.getChildNodes().getLength() > 0) {
            Text textBeforeClosingTag = document.createTextNode(formatting);
            this.domNode.appendChild(textBeforeClosingTag);
        }
        if (this instanceof XmlElement) {
            int depthPlusOne = depth + 1;
            XmlElement element = (XmlElement)this;
            for (XmlNode xmlNode : element.getChildElements()) {
                xmlNode.format(depthPlusOne);
            }
            for (XmlNode xmlNode : element.getComments()) {
                xmlNode.format(depthPlusOne);
            }
        }
    }

    public final void removeFormatting() {
        Node prevSibling;
        this.validateEdit();
        NodeList nodes = this.domNode.getChildNodes();
        ArrayList<Node> textNodesToRemove = new ArrayList<Node>();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                textNodesToRemove.add(child);
            }
            ++i;
        }
        for (Node n2 : textNodesToRemove) {
            this.domNode.removeChild(n2);
        }
        if (this instanceof XmlElement) {
            XmlElement element = (XmlElement)this;
            for (XmlNode xmlNode : element.getChildElements()) {
                xmlNode.removeFormatting();
            }
            for (XmlNode xmlNode : element.getComments()) {
                xmlNode.removeFormatting();
            }
        }
        if ((prevSibling = this.domNode.getPreviousSibling()) != null && prevSibling.getNodeType() == 3 && prevSibling.getNodeValue().trim().length() == 0) {
            this.domNode.getParentNode().removeChild(prevSibling);
        }
    }

    public abstract void remove();

    public final void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        if (this.listeners != null) {
            listeners.addAll(this.listeners);
        }
        listeners.add(listener);
        this.listeners = listeners;
    }

    public final void removeListener(Listener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            if (this.listeners.size() == 1) {
                this.listeners = null;
            } else {
                ArrayList<Listener> listeners = new ArrayList<Listener>();
                for (Listener x : this.listeners) {
                    if (x.equals(listener)) continue;
                    listeners.add(x);
                }
                this.listeners = listeners;
            }
        }
    }

    protected final void notifyListeners(Event event) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                try {
                    listener.handle(event);
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
            }
        }
    }

    public static class Event {
        private final EventType type;
        private final XmlNode node;

        public Event(EventType type, XmlNode node) {
            this.type = type;
            this.node = node;
        }

        public EventType getType() {
            return this.type;
        }

        public XmlNode getNode() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        PRE_CHILD_ELEMENT_ADD,
        POST_CHILD_ELEMENT_ADD,
        PRE_CHILD_ELEMENT_REMOVE,
        POST_CHILD_ELEMENT_REMOVE;

    }

    public static abstract class Listener {
        public abstract void handle(Event var1);
    }
}

