/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.dtd.internal.DtdParserImpl;
import org.eclipse.sapphire.modeling.xml.schema.UrlResolver;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;

public final class DtdParser {
    public static XmlDocumentSchema parseFromString(String dtd) {
        try {
            String content = dtd;
            DtdParserImpl parser = new DtdParserImpl(new StringReader(content));
            parser.Start();
            if (!parser.entities.isEmpty()) {
                for (Map.Entry<String, String> entity : parser.entities.entrySet()) {
                    content = content.replace("%" + entity.getKey() + ";", entity.getValue());
                }
                parser = new DtdParserImpl(new StringReader(content));
                parser.Start();
            }
            return parser.schema.create();
        }
        catch (Exception e) {
            String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{"##string##"});
            LoggingService.log((Status)Status.createErrorStatus((String)message, (Throwable)e));
            return new XmlDocumentSchema.Factory().create();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlDocumentSchema parseFromUrl(String baseLocation, String url) {
        URL dtdLocationUrl = null;
        try {
            dtdLocationUrl = new URL(UrlResolver.resolve(baseLocation, url));
        }
        catch (MalformedURLException e) {
            String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{url});
            LoggingService.log((Status)Status.createErrorStatus((String)message, (Throwable)e));
        }
        if (dtdLocationUrl == null) return new XmlDocumentSchema.Factory().create();
        InputStream in = null;
        in = dtdLocationUrl.openStream();
        XmlDocumentSchema xmlDocumentSchema = DtdParser.parseFromString(MiscUtil.readTextContent((InputStream)in));
        if (in == null) return xmlDocumentSchema;
        try {
            in.close();
            return xmlDocumentSchema;
        }
        catch (IOException iOException) {}
        return xmlDocumentSchema;
        catch (Exception e) {
            try {
                String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{url});
                LoggingService.log((Status)Status.createErrorStatus((String)message, (Throwable)e));
                if (in == null) return new XmlDocumentSchema.Factory().create();
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return new XmlDocumentSchema.Factory().create();
            }
            catch (IOException iOException) {}
            return new XmlDocumentSchema.Factory().create();
        }
    }

    private static final class Resources
    extends NLS {
        public static String parseFailed;

        static {
            Resources.initializeMessages((String)DtdParser.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

