/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.text.NumberFormat;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ValueKeyword;

public final class DoubleValueKeyword
extends ValueKeyword {
    public DoubleValueKeyword(String keyword, String value) {
        super(keyword, value);
    }

    protected String createDisplayString(String keyword, String value) {
        String formattedValue = value;
        try {
            double parsedValue = Double.parseDouble(value);
            formattedValue = NumberFormat.getInstance().format(parsedValue);
        }
        catch (NumberFormatException e) {
            LoggingService.log(e);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(keyword);
        buf.append(" (");
        buf.append(formattedValue);
        buf.append(")");
        return buf.toString();
    }
}

