/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelService {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private IModelElement element;

    protected final void init(IModelElement element) {
        this.element = element;
    }

    public final IModelElement element() {
        return this.element;
    }

    public final <T> T nearest(Class<T> particleType) {
        return this.element.nearest(particleType);
    }

    public final <A> A adapt(Class<A> adapterType) {
        return this.element.adapt(adapterType);
    }

    public final void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(Event event) {
        for (Listener listener : this.listeners) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    public void dispose() {
    }

    public static class Event {
        private final ModelService service;

        public Event(ModelService service) {
            this.service = service;
        }

        public ModelService service() {
            return this.service;
        }
    }

    public static abstract class Listener {
        public abstract void handleEvent(Event var1);
    }
}

