/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.annotations.Whitespace;

public class StandardValueNormalizationService
extends ValueNormalizationService {
    private boolean trim;
    private boolean collapse;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        Whitespace ws = property.getAnnotation(Whitespace.class);
        if (ws == null) {
            this.trim = true;
            this.collapse = false;
        } else {
            this.trim = ws.trim();
            this.collapse = ws.collapse();
        }
    }

    public String normalize(String str) {
        String text = str;
        if (str != null) {
            if (this.trim) {
                text = StandardValueNormalizationService.trim(text);
            }
            if (this.collapse) {
                text = StandardValueNormalizationService.collapse(text);
            }
        }
        return text;
    }

    public static final String trim(String str) {
        return str.trim();
    }

    public static final String collapse(String str) {
        String text = str;
        StringBuilder buf = new StringBuilder();
        boolean skipNextWhitespace = true;
        int i = 0;
        int n = text.length();
        while (i < n) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!skipNextWhitespace) {
                    buf.append(' ');
                    skipNextWhitespace = true;
                }
            } else {
                buf.append(ch);
                skipNextWhitespace = false;
            }
            ++i;
        }
        int length = buf.length();
        if (length > 0 && buf.charAt(length - 1) == ' ') {
            buf.deleteCharAt(length - 1);
        }
        return buf.toString();
    }
}

