/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.localization;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalizationService {
    public abstract String text(String var1, CapitalizationType var2, boolean var3);

    public final String label(Class<?> cl, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String sourceLangString = null;
        Label labelAnnotation = cl.getAnnotation(Label.class);
        if (labelAnnotation != null) {
            sourceLangString = labelAnnotation.standard().trim();
        }
        if (sourceLangString == null || sourceLangString.length() == 0) {
            String className = cl.getName();
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                className = className.substring(lastDot + 1);
            }
            sourceLangString = LocalizationUtil.transformCamelCaseToLabel(className);
        }
        return this.text(sourceLangString, capitalizationType, includeMnemonic);
    }

    public String transform(String string, CapitalizationType capitalizationType, boolean includeMnemonic) {
        StringBuilder result = new StringBuilder(string);
        int mnemonicDesignatorPos = string.indexOf(38);
        if (mnemonicDesignatorPos != -1) {
            result.deleteCharAt(mnemonicDesignatorPos);
        }
        capitalizationType.changeTo(result);
        if (includeMnemonic && mnemonicDesignatorPos != -1) {
            result.insert(mnemonicDesignatorPos, '&');
        }
        return result.toString();
    }
}

