/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CountConstraintValidationService
extends ModelPropertyValidationService<ModelElementList<?>> {
    private CountConstraint constraint;

    @Override
    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.constraint = property.getAnnotation(CountConstraint.class);
    }

    @Override
    public Status validate() {
        ModelElementList list = (ModelElementList)this.target();
        int count = list.size();
        String message = null;
        if (count < this.constraint.min()) {
            message = this.constraint.min() == 1 ? Resources.bind(Resources.countConstraintTooFewAtLeastOne, this.property().getType().getLabel(true, CapitalizationType.NO_CAPS, false)) : Resources.bind(Resources.countConstraintTooFew, this.property().getType().getLabel(true, CapitalizationType.NO_CAPS, false), String.valueOf(this.constraint.min()));
        } else if (count > this.constraint.max()) {
            message = Resources.bind(Resources.countConstraintTooMany, this.property().getType().getLabel(true, CapitalizationType.NO_CAPS, false), String.valueOf(this.constraint.max()));
        }
        if (message == null) {
            return Status.createOkStatus();
        }
        return Status.createErrorStatus(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ListProperty && property.hasAnnotation(CountConstraint.class);
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new CountConstraintValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String countConstraintTooFew;
        public static String countConstraintTooFewAtLeastOne;
        public static String countConstraintTooMany;

        static {
            Resources.initializeMessages(CountConstraintValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

