/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import java.util.Collections;
import java.util.SequencedCollection;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.ReferenceService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesValidationService
extends ModelPropertyValidationService<Value<?>> {
    @Override
    public Status validate() {
        PossibleValuesService valuesProvider;
        Value value = (Value)this.target();
        IModelElement modelElement = value.parent();
        String valueString = value.getText(true);
        if (valueString != null && (valuesProvider = modelElement.service(value.getProperty(), PossibleValuesService.class)) != null) {
            Status.Severity severity;
            SequencedCollection<String> values = valuesProvider.values();
            for (String v : values) {
                if (v != null) continue;
                String msg = NLS.bind(Resources.valuesProviderReturnedNull, valuesProvider.getClass().getName());
                LoggingService.log(Status.createErrorStatus(msg));
                values = Collections.emptyList();
            }
            boolean found = false;
            if (valuesProvider.isCaseSensitive()) {
                found = values.contains(valueString);
            } else {
                for (String v : values) {
                    if (!v.equalsIgnoreCase(valueString)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && (severity = valuesProvider.getInvalidValueSeverity(valueString)) != Status.Severity.OK) {
                String message = valuesProvider.getInvalidValueMessage(valueString);
                return Status.createStatus(severity, message);
            }
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && element.service(property, PossibleValuesService.class) != null && element.service(property, ReferenceService.class) == null;
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new PossibleValuesValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String valuesProviderReturnedNull;

        static {
            Resources.initializeMessages(PossibleValuesValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

