/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.architecture.IArchitecture;
import org.eclipse.sapphire.samples.architecture.IComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Architecture
extends ModelElement
implements IArchitecture {
    private ModelElementList<IComponent> components;
    private Value<String> description;

    public Architecture(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Architecture(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IComponent> getComponents() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.components == null) {
                this.refresh((ModelProperty)PROP_COMPONENTS, true);
            }
            return this.components;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!Architecture.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COMPONENTS) {
                if (this.components == null) {
                    if (force) {
                        this.components = new ModelElementList((IModelElement)this, PROP_COMPONENTS);
                        ListBindingImpl binding = this.resource().binding(PROP_COMPONENTS);
                        this.components.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_COMPONENTS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COMPONENTS);
                    boolean notified = this.components.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_COMPONENTS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_DESCRIPTION && (this.description != null || force)) {
                Value<String> oldValue = this.description;
                String val = this.resource().binding(PROP_DESCRIPTION).read();
                this.description = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                this.description.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                if (oldValue != null) {
                    if (this.description.equals(oldValue)) {
                        this.description = oldValue;
                    }
                    if (this.description != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DESCRIPTION, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COMPONENTS) {
            return this.getComponents();
        }
        if (property == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        super.write(property, value);
    }
}

