/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.calendar.ui.CalendarEditor;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContactDetailsJumpHandler
extends SapphireJumpActionHandler {
    protected void initDependencies(List<String> dependencies) {
        super.initDependencies(dependencies);
        dependencies.add(IAttendee.PROP_IN_CONTACTS_DATABASE.getName());
    }

    protected boolean computeEnablementState() {
        if (super.computeEnablementState()) {
            IAttendee attendee = (IAttendee)this.getModelElement();
            return (Boolean)attendee.isInContactsDatabase().getContent();
        }
        return false;
    }

    protected Object run(SapphireRenderingContext context) {
        CalendarEditor editor = (CalendarEditor)((Object)context.getPart().nearest(CalendarEditor.class));
        ContactDetailsJumpHandler.jump(editor, this.getModelElement());
        return null;
    }

    public static void jump(CalendarEditor editor, IModelElement modelElement) {
        IAttendee attendee = (IAttendee)modelElement;
        String name = attendee.getName().getText();
        if (name != null) {
            MasterDetailsEditorPage contactsFormPage;
            MasterDetailsContentOutline content;
            MasterDetailsContentNode contactNode;
            IContact contact = null;
            for (IContact c : editor.getContactsDatabase().getContacts()) {
                if (!name.equals(c.getName().getText())) continue;
                contact = c;
                break;
            }
            if (contact != null && (contactNode = (content = (contactsFormPage = (MasterDetailsEditorPage)editor.getPage("Contacts")).getContentTree()).getRoot().findNodeByModelElement((IModelElement)contact)) != null) {
                contactNode.select();
                editor.showPage("Contacts");
            }
        }
    }
}

