/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IContactsDatabase;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;

public final class CreateContactActionHandler
extends SapphireActionHandler {
    private ModelPropertyListener listener;
    private ValueProperty property;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.property = (ValueProperty)((SapphirePropertyEditor)action.getPart()).getProperty();
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                CreateContactActionHandler.this.refreshEnablementState();
            }
        };
        IModelElement element = this.getModelElement();
        ((IContactsDatabase)element.nearest(IContactsDatabase.class)).addListener(this.listener, "Contacts/Name");
        element.addListener(this.listener, this.property.getName());
        this.refreshEnablementState();
    }

    private void refreshEnablementState() {
        boolean enabled;
        IModelElement element = this.getModelElement();
        String name = element.read(this.property).getText();
        IContactsDatabase cdb = (IContactsDatabase)element.nearest(IContactsDatabase.class);
        if (name == null) {
            enabled = false;
        } else {
            enabled = true;
            for (IContact contact : cdb.getContacts()) {
                if (!name.equals(contact.getName().getText())) continue;
                enabled = false;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    protected Object run(SapphireRenderingContext context) {
        IModelElement element = this.getModelElement();
        String name = element.read(this.property).getText();
        IContactsDatabase cdb = (IContactsDatabase)element.nearest(IContactsDatabase.class);
        IContact newContact = (IContact)cdb.getContacts().addNewElement();
        newContact.setName(name);
        return null;
    }

    public void dispose() {
        super.dispose();
        IModelElement element = this.getModelElement();
        ((IContactsDatabase)element.nearest(IContactsDatabase.class)).removeListener(this.listener, "Contacts/Name");
        element.removeListener(this.listener, this.property.getName());
    }
}

