/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.DerivedValueService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.ISendContactOp;
import org.eclipse.sapphire.samples.contacts.internal.SendContactOpMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SendContactOp
extends ModelElement
implements ISendContactOp {
    private Transient<IContact> contact;
    private Value<String> messageBody;
    private Value<String> to;

    public SendContactOp(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public SendContactOp(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transient<IContact> getContact() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.contact == null) {
                this.refresh((ModelProperty)PROP_CONTACT, true);
            }
            return this.contact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContact(IContact object) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Transient<IContact> oldTransient = this.contact;
            this.contact = new Transient((IModelElement)this, PROP_CONTACT, (Object)object);
            this.contact.init();
            ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONTACT);
            if (oldTransient == null) {
                if (object != null) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_CONTACT, enablementRefreshResult);
                }
            } else {
                if (this.contact.equals(oldTransient)) {
                    this.contact = oldTransient;
                }
                if (this.contact != oldTransient || enablementRefreshResult.changed()) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_CONTACT, enablementRefreshResult);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getMessageBody() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.messageBody == null) {
                this.refresh((ModelProperty)PROP_MESSAGE_BODY, true);
            }
            return this.messageBody;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getTo() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.to == null) {
                this.refresh((ModelProperty)PROP_TO, true);
            }
            return this.to;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTo(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TO.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_TO, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_TO, true);
            if (!SendContactOp.equal((String)this.to.getText(false), (String)value)) {
                this.resource().binding(PROP_TO).write(value);
                this.refresh((ModelProperty)PROP_TO, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status execute(ProgressMonitor monitor) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return SendContactOpMethods.execute(this, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CONTACT) {
                if (this.contact == null) {
                    if (force) {
                        this.setContact(null);
                    }
                } else {
                    this.setContact((IContact)this.contact.content());
                }
            } else if (property == PROP_MESSAGE_BODY) {
                if (this.messageBody != null || force) {
                    Value<String> oldValue = this.messageBody;
                    String val = ((DerivedValueService)this.service((ModelProperty)PROP_MESSAGE_BODY, DerivedValueService.class)).getDerivedValue();
                    this.messageBody = new Value((IModelElement)this, PROP_MESSAGE_BODY, ((ValueNormalizationService)this.service((ModelProperty)PROP_MESSAGE_BODY, ValueNormalizationService.class)).normalize(PROP_MESSAGE_BODY.encodeKeywords(val)));
                    this.messageBody.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_MESSAGE_BODY);
                    if (oldValue != null) {
                        if (this.messageBody.equals(oldValue)) {
                            this.messageBody = oldValue;
                        }
                        if (this.messageBody != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_MESSAGE_BODY, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_TO && (this.to != null || force)) {
                Value<String> oldValue = this.to;
                String val = this.resource().binding(PROP_TO).read();
                this.to = new Value((IModelElement)this, PROP_TO, ((ValueNormalizationService)this.service((ModelProperty)PROP_TO, ValueNormalizationService.class)).normalize(PROP_TO.encodeKeywords(val)));
                this.to.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_TO);
                if (oldValue != null) {
                    if (this.to.equals(oldValue)) {
                        this.to = oldValue;
                    }
                    if (this.to != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TO, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CONTACT) {
            return this.getContact();
        }
        if (property == PROP_MESSAGE_BODY) {
            return this.getMessageBody();
        }
        if (property == PROP_TO) {
            return this.getTo();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_TO) {
            this.setTo((String)value);
            return;
        }
        super.write(property, value);
    }

    public void write(TransientProperty property, Object object) {
        if ((property = (TransientProperty)property.refine((IModelElement)this)) == PROP_CONTACT) {
            this.setContact((IContact)object);
            return;
        }
        super.write(property, object);
    }
}

