/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.DerivedValueService;
import org.eclipse.sapphire.samples.contacts.IAddress;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IPhoneNumber;
import org.eclipse.sapphire.samples.contacts.ISendContactOp;

public final class SendContactOpContentProvider
extends DerivedValueService {
    public String getDerivedValue() {
        ISendContactOp op = (ISendContactOp)this.element();
        IContact contact = (IContact)op.getContact().content();
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body>\n");
        if (contact != null) {
            IAddress address;
            buf.append("<b>");
            buf.append(contact.getName().getText());
            buf.append("</b>\n");
            buf.append("<br/><hr/>\n");
            if (!contact.getPhoneNumbers().isEmpty()) {
                buf.append("<p><table>\n");
                for (IPhoneNumber phone : contact.getPhoneNumbers()) {
                    buf.append("<tr><td><i>");
                    buf.append(phone.getType().getText());
                    buf.append("</i></td><td>");
                    String areaCode = phone.getAreaCode().getText();
                    String localNumber = phone.getLocalNumber().getText();
                    if (areaCode != null) {
                        buf.append('(');
                        buf.append(areaCode);
                        buf.append(") ");
                    }
                    buf.append(localNumber);
                    buf.append("</td></tr>\n");
                }
                buf.append("</table></p>\n");
            }
            if ((address = contact.getAddress()) != null && address.getStreet().getContent() != null) {
                buf.append("<p>");
                buf.append(address.getStreet().getText());
                buf.append("<br/>");
                buf.append(address.getCity().getText());
                buf.append(", ");
                buf.append(address.getState().getText());
                buf.append(' ');
                buf.append(address.getZipCode().getText());
                buf.append("</p>\n");
            }
        }
        buf.append("</body></html>");
        return buf.toString();
    }
}

