/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.java.t0003;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.java.t0003.ITestElement;
import org.osgi.framework.Bundle;

public final class TestJava0003
extends SapphireTestCase {
    private static final String PACKAGE_NAME = "org.eclipse.sapphire.tests.java.t0003";

    private TestJava0003(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Java0003");
        suite.addTest((Test)new TestJava0003("testTopLevel"));
        suite.addTest((Test)new TestJava0003("testInner"));
        suite.addTest((Test)new TestJava0003("testWithCustomClassLocator"));
        return suite;
    }

    public void testTopLevel() {
        ITestElement element = (ITestElement)ITestElement.TYPE.instantiate();
        element.setSomeClass("org.eclipse.sapphire.tests.java.t0003.TestClass");
        JavaType type = (JavaType)element.getSomeClass().resolve();
        TestJava0003.assertNotNull((Object)type);
    }

    public void testInner() {
        ITestElement element = (ITestElement)ITestElement.TYPE.instantiate();
        element.setSomeClass("org.eclipse.sapphire.tests.java.t0003.TestClass$Inner");
        JavaType type = (JavaType)element.getSomeClass().resolve();
        TestJava0003.assertNotNull((Object)type);
    }

    public void testWithCustomClassLocator() {
        RootXmlResource resource = new RootXmlResource(){

            public <A> A adapt(Class<A> adapterType) {
                if (adapterType == ClassLocator.class) {
                    final Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                    return (A)new ClassLocator(){

                        public Class<?> find(String name) {
                            try {
                                return bundle.loadClass(name);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                return null;
                            }
                        }
                    };
                }
                return (A)super.adapt(adapterType);
            }
        };
        ITestElement element = (ITestElement)ITestElement.TYPE.instantiate((Resource)resource);
        element.setSomeClass("org.eclipse.sapphire.tests.java.t0003.TestClass");
        JavaType type = (JavaType)element.getSomeClass().resolve();
        TestJava0003.assertNull((Object)type);
        element.setSomeClass("org.eclipse.core.resources.IFile");
        type = (JavaType)element.getSomeClass().resolve();
        TestJava0003.assertNotNull((Object)type);
    }
}

