/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.serialization;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.tests.modeling.serialization.ISerializationTestsModel;
import org.eclipse.sapphire.tests.modeling.serialization.ThreeChoiceAnswer;
import org.eclipse.sapphire.tests.modeling.serialization.ThreeChoiceAnswerCustomized;

public final class SerializationTests
extends TestCase {
    private SerializationTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SerializationTests");
        suite.addTest((Test)new SerializationTests("testEnumSerialization1"));
        suite.addTest((Test)new SerializationTests("testEnumSerialization2"));
        suite.addTest((Test)new SerializationTests("testEnumSerialization3"));
        return suite;
    }

    public void testEnumSerialization1() throws Exception {
        ISerializationTestsModel model = (ISerializationTestsModel)ISerializationTestsModel.TYPE.instantiate();
        model.setEnumProperty1("YES");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("yes");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("yEs");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("maybe");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("mAyBe");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("no");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("NO");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1(ThreeChoiceAnswer.YES);
        SerializationTests.assertEquals((String)"YES", (String)model.getEnumProperty1().getText());
        model.setEnumProperty1(ThreeChoiceAnswer.MAYBE);
        SerializationTests.assertEquals((String)"MAYBE", (String)model.getEnumProperty1().getText());
        model.setEnumProperty1(ThreeChoiceAnswer.NO);
        SerializationTests.assertEquals((String)"NO", (String)model.getEnumProperty1().getText());
        model.setEnumProperty1("true");
        SerializationTests.assertNull((Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("false");
        SerializationTests.assertNull((Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("sldkfjsdlfskd");
        SerializationTests.assertNull((Object)model.getEnumProperty1().getContent());
        model.setEnumProperty1("-55");
        SerializationTests.assertNull((Object)model.getEnumProperty1().getContent());
    }

    public void testEnumSerialization2() throws Exception {
        ISerializationTestsModel model = (ISerializationTestsModel)ISerializationTestsModel.TYPE.instantiate();
        model.setEnumProperty2("YES");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("yes");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("yEs");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("true");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("TRUE");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("1");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("maybe");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("mAyBe");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("0");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("no");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("NO");
        SerializationTests.assertNull((Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("false");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("FALSE");
        SerializationTests.assertNull((Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("-1");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2(ThreeChoiceAnswerCustomized.YES);
        SerializationTests.assertEquals((String)"yes", (String)model.getEnumProperty2().getText());
        model.setEnumProperty2(ThreeChoiceAnswerCustomized.MAYBE);
        SerializationTests.assertEquals((String)"maybe", (String)model.getEnumProperty2().getText());
        model.setEnumProperty2(ThreeChoiceAnswerCustomized.NO);
        SerializationTests.assertEquals((String)"no", (String)model.getEnumProperty2().getText());
        model.setEnumProperty2("sldkfjsdlfskd");
        SerializationTests.assertNull((Object)model.getEnumProperty2().getContent());
        model.setEnumProperty2("-55");
        SerializationTests.assertNull((Object)model.getEnumProperty2().getContent());
    }

    public void testEnumSerialization3() throws Exception {
        ISerializationTestsModel model = (ISerializationTestsModel)ISerializationTestsModel.TYPE.instantiate();
        model.setEnumProperty3("1");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("0");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("-1");
        SerializationTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("YES");
        SerializationTests.assertNull((Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("MAYBE");
        SerializationTests.assertNull((Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("NO");
        SerializationTests.assertNull((Object)model.getEnumProperty3().getContent());
        model.setEnumProperty3("5");
        SerializationTests.assertNull((Object)model.getEnumProperty3().getContent());
    }
}

