/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.workspace.t0001;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.workspace.TestWorkspace;
import org.eclipse.sapphire.tests.workspace.t0001.ITestElement;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class TestWorkspace0001
extends TestWorkspace {
    private IProject a;
    private IFile aa;
    private IFolder ab;
    private IFile aba;
    private IProject b;
    private IFile baaaaa;

    private TestWorkspace0001(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Workspace0001");
        suite.addTest((Test)new TestWorkspace0001("testWorkspaceRelativePath"));
        suite.addTest((Test)new TestWorkspace0001("testProjectRelativePath"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.createProject("a");
        this.aa = this.createFile(this.a, "a.txt");
        this.ab = this.createFolder(this.a, "b");
        this.aba = this.createFile(this.a, "b/a.txt");
        this.b = this.createProject("b");
        this.baaaaa = this.createFile(this.b, "a/a/a/a.txt");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteProject("a");
        this.deleteProject("b");
    }

    public void testWorkspaceRelativePath() throws Exception {
        ValueProperty property = ITestElement.PROP_WORKSPACE_RELATIVE_PATH;
        ITestElement element = (ITestElement)ITestElement.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(this.aa))));
        this.testValidationOk(element, property, this.a.getFullPath());
        this.testValidationOk(element, property, this.aa.getFullPath());
        this.testValidationOk(element, property, this.ab.getFullPath());
        this.testValidationOk(element, property, this.aba.getFullPath());
        this.testValidationOk(element, property, this.b.getFullPath());
        this.testValidationOk(element, property, this.baaaaa.getFullPath());
        this.testValidationError(element, property, this.ab.getFile("b.txt").getFullPath());
        this.testValidationError(element, property, this.b.getLocation());
    }

    public void testProjectRelativePath() throws Exception {
        ValueProperty property = ITestElement.PROP_PROJECT_RELATIVE_PATH;
        ITestElement element = (ITestElement)ITestElement.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(this.aa))));
        this.testValidationOk(element, property, this.aa.getProjectRelativePath());
        this.testValidationOk(element, property, this.ab.getProjectRelativePath());
        this.testValidationOk(element, property, this.aba.getProjectRelativePath());
        this.testValidationError(element, property, this.ab.getFile("b.txt").getFullPath());
        this.testValidationError(element, property, this.b.getLocation());
        this.testValidationError(element, property, this.a.getFullPath());
        this.testValidationError(element, property, this.aa.getFullPath());
        this.testValidationError(element, property, this.ab.getFullPath());
        this.testValidationError(element, property, this.baaaaa.getProjectRelativePath());
        element = (ITestElement)ITestElement.TYPE.instantiate();
        this.testValidationError(element, property, this.aa.getProjectRelativePath(), "No context project found.");
    }

    private void testValidationOk(ITestElement element, ValueProperty property, IPath path) {
        element.write(property, new Path(path.toPortableString()));
        TestWorkspace0001.assertValidationOk(element.read(property));
    }

    private void testValidationError(ITestElement element, ValueProperty property, IPath path) {
        this.testValidationError(element, property, path, "File or folder \"" + path.toPortableString() + "\" does not exist.");
    }

    private void testValidationError(ITestElement element, ValueProperty property, IPath path, String expectedErrorMessage) {
        element.write(property, new Path(path.toPortableString()));
        TestWorkspace0001.assertValidationError(element.read(property), expectedErrorMessage);
    }
}

