/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.SapphireDiagramActionHandler;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.ImagePlacement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.features.TextUtil;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;

public class SapphireAddNodeFeature
extends AbstractAddShapeFeature {
    private static final IColorConstant DEFAULT_TEXT_FOREGROUND = new ColorConstant(51, 51, 153);
    private static final IColorConstant DEFAULT_NODE_FOREGROUND = new ColorConstant(51, 51, 153);
    public static final int DEFAULT_NODE_WIDTH = 100;
    public static final int DEFAULT_NODE_HEIGHT = 30;
    private static final int DEFAULT_TEXT_HEIGHT = 20;

    public SapphireAddNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        SapphireAction dropAction;
        SapphireDiagramActionHandler dropHandler;
        Object newObj = context.getNewObject();
        if (newObj instanceof DiagramNodePart) {
            return true;
        }
        return context.getTargetContainer() instanceof Diagram && (dropHandler = (SapphireDiagramActionHandler)(dropAction = ((SapphireDiagramEditor)this.getDiagramEditor()).getPart().getAction("Sapphire.Drop")).getFirstActiveHandler()) != null && dropHandler.canExecute(newObj);
    }

    public PictogramElement add(IAddContext context) {
        Rectangle rectangle;
        int ltY;
        int ltX;
        Object newObj = context.getNewObject();
        DiagramNodePart nodePart = null;
        if (!(newObj instanceof DiagramNodePart)) {
            SapphireDiagramEditorPagePart diagramPart = ((SapphireDiagramEditor)this.getDiagramEditor()).getPart();
            SapphireAction dropAction = diagramPart.getAction("Sapphire.Drop");
            SapphireDiagramActionHandler dropHandler = (SapphireDiagramActionHandler)dropAction.getFirstActiveHandler();
            DiagramRenderingContext diagramCtx = ((SapphireDiagramFeatureProvider)this.getFeatureProvider()).getRenderingContext((ISapphirePart)diagramPart);
            diagramCtx.setCurrentMouseLocation(context.getX(), context.getY());
            diagramCtx.setObject(newObj);
            dropHandler.execute((SapphireRenderingContext)diagramCtx);
            return null;
        }
        nodePart = (DiagramNodePart)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IDiagramNodeDef nodeDef = (IDiagramNodeDef)nodePart.getDefinition();
        int width = SapphireAddNodeFeature.getNodeWidth(nodePart, context.getWidth());
        int height = SapphireAddNodeFeature.getNodeHeight(nodePart, context.getHeight());
        if (context.getX() != -1 && context.getY() != -1) {
            ltX = context.getX();
            ltY = context.getY();
        } else {
            SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
            Point np = diagramEditor.getDefaultNodePosition();
            ltX = np.getX();
            ltY = np.getY();
        }
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        IGaService gaService = Graphiti.getGaService();
        if (nodePart.getImageId() == null) {
            rectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 8, 8);
            rectangle.setForeground(this.manageColor(DEFAULT_NODE_FOREGROUND));
            gaService.setRenderingStyle((AbstractStyle)rectangle, PredefinedColoredAreas.getBlueWhiteGlossAdaptions());
            rectangle.setLineWidth(Integer.valueOf(1));
            gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, ltX, ltY, width, height);
            this.link((PictogramElement)containerShape, nodePart);
        } else {
            rectangle = gaService.createRectangle((GraphicsAlgorithmContainer)containerShape);
            rectangle.setFilled(Boolean.valueOf(false));
            rectangle.setLineVisible(Boolean.valueOf(false));
            gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, ltX, ltY, width, height);
            this.link((PictogramElement)containerShape, nodePart);
            Shape shape = peCreateService.createShape(containerShape, false);
            String imageId = nodePart.getImageId();
            Image image = gaService.createImage((GraphicsAlgorithmContainer)shape, imageId);
            int imageWidth = SapphireAddNodeFeature.getImageWidth(nodePart);
            int imageHeight = SapphireAddNodeFeature.getImageHeight(nodePart);
            Point imageLocation = this.getImageLocation(nodePart, width, height, imageWidth, imageHeight);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "nodeImageId", imageId);
            gaService.setLocationAndSize((GraphicsAlgorithm)image, imageLocation.getX(), imageLocation.getY(), imageWidth, imageHeight);
        }
        if (nodeDef.getLabel().element() != null) {
            Shape shape = peCreateService.createShape(containerShape, false);
            Diagram diagram = (Diagram)context.getTargetContainer();
            Text text = TextUtil.createDefaultText(diagram, (GraphicsAlgorithmContainer)shape, nodePart.getLabel());
            text.setForeground(this.manageColor(DEFAULT_TEXT_FOREGROUND));
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            Point labelLocation = this.getLabelLocation(nodePart);
            int labelWidth = nodePart.getLabelWidth();
            int labelHeight = nodePart.getLabelHeight();
            int lwidth = labelWidth > 0 ? labelWidth : width;
            int lheight = labelHeight > 0 ? labelHeight : 20;
            int textX = labelLocation.getX();
            if (lwidth == width) {
                lwidth -= 6;
                textX += 3;
            }
            int textY = labelLocation.getY();
            if (nodePart.getImageId() == null && lheight < height) {
                textY += height - lheight >> 1;
            }
            gaService.setLocationAndSize((GraphicsAlgorithm)text, textX, textY, lwidth, lheight);
            this.link((PictogramElement)shape, nodePart);
            IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
            directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
            directEditingInfo.setPictogramElement((PictogramElement)shape);
            directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        }
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        nodePart.setNodeBounds(ltX, ltY, width, height);
        DiagramRenderingContext renderingCtx = new DiagramRenderingContext((ISapphirePart)nodePart, (SapphireDiagramEditor)this.getDiagramEditor(), (GraphicsAlgorithmContainer)containerShape);
        SapphireDiagramFeatureProvider sfp = (SapphireDiagramFeatureProvider)this.getFeatureProvider();
        sfp.addRenderingContext((SapphirePart)nodePart, renderingCtx);
        return containerShape;
    }

    public static int getNodeWidth(DiagramNodePart nodePart, int widthParam) {
        if (widthParam > 0) {
            return widthParam;
        }
        if (nodePart.getNodeWidth() > 0) {
            return nodePart.getNodeWidth();
        }
        int width = 0;
        int labelWidth = nodePart.getLabelWidth();
        String imageId = nodePart.getImageId();
        if (imageId != null) {
            int imageWidth = SapphireAddNodeFeature.getImageWidth(nodePart);
            ImagePlacement imagePlacement = nodePart.getImagePlacement();
            if (imagePlacement == ImagePlacement.TOP || imagePlacement == ImagePlacement.BOTTOM) {
                width = Math.max(labelWidth, imageWidth);
            } else if (imagePlacement == ImagePlacement.LEFT || imagePlacement == ImagePlacement.RIGHT) {
                int horizaontalSpacing = nodePart.getHorizontalSpacing();
                width = labelWidth + imageWidth + horizaontalSpacing;
            }
        } else {
            width = labelWidth;
        }
        if (width <= 0) {
            width = 100;
        }
        return width;
    }

    public static int getNodeHeight(DiagramNodePart nodePart, int heightParam) {
        if (heightParam > 0) {
            return heightParam;
        }
        if (nodePart.getNodeHeight() > 0) {
            return nodePart.getNodeHeight();
        }
        int height = 0;
        int labelHeight = nodePart.getLabelHeight();
        String imageId = nodePart.getImageId();
        if (imageId != null) {
            int imageHeight = SapphireAddNodeFeature.getImageHeight(nodePart);
            ImagePlacement imagePlacement = nodePart.getImagePlacement();
            if (imagePlacement == ImagePlacement.TOP || imagePlacement == ImagePlacement.BOTTOM) {
                int verticalSpacing = nodePart.getVerticalSpacing();
                height = labelHeight + imageHeight + verticalSpacing;
            } else if (imagePlacement == ImagePlacement.LEFT || imagePlacement == ImagePlacement.RIGHT) {
                height = Math.max(labelHeight, imageHeight);
            }
        } else {
            height = labelHeight;
        }
        if (height <= 0) {
            height = 30;
        }
        return height;
    }

    private Point getImageLocation(DiagramNodePart nodePart, int nodeWidth, int nodeHeight, int imageWidth, int imageHeight) {
        ImagePlacement imagePlacement = nodePart.getImagePlacement();
        if (imagePlacement == ImagePlacement.LEFT) {
            return new Point(0, 0);
        }
        if (imagePlacement == ImagePlacement.TOP) {
            int offsetX = nodeWidth - imageWidth >> 1;
            return new Point(offsetX, 0);
        }
        if (imagePlacement == ImagePlacement.BOTTOM) {
            int labelHeight = nodePart.getLabelHeight();
            int verticalSpacing = nodePart.getVerticalSpacing();
            int offsetX = nodeWidth - imageWidth >> 1;
            return new Point(offsetX, labelHeight + verticalSpacing);
        }
        if (imagePlacement == ImagePlacement.RIGHT) {
            int labelWidth = nodePart.getLabelWidth();
            int horizontalSpacing = nodePart.getHorizontalSpacing();
            return new Point(labelWidth + horizontalSpacing, 0);
        }
        return new Point(0, 0);
    }

    private Point getLabelLocation(DiagramNodePart nodePart) {
        ImagePlacement imagePlacement = nodePart.getImagePlacement();
        if (imagePlacement == ImagePlacement.TOP) {
            int imageHeight = SapphireAddNodeFeature.getImageHeight(nodePart);
            int verticalSpacing = nodePart.getVerticalSpacing();
            return new Point(0, imageHeight + verticalSpacing);
        }
        if (imagePlacement == ImagePlacement.BOTTOM || imagePlacement == ImagePlacement.RIGHT) {
            return new Point(0, 0);
        }
        if (imagePlacement == ImagePlacement.LEFT) {
            int imageWidth = SapphireAddNodeFeature.getImageWidth(nodePart);
            int horizontalSpacing = nodePart.getHorizontalSpacing();
            return new Point(imageWidth + horizontalSpacing, 0);
        }
        return new Point(0, 0);
    }

    private static int getImageWidth(DiagramNodePart nodePart) {
        String imageId = nodePart.getImageId();
        if (imageId != null) {
            int imageWidth = nodePart.getImageWidth();
            if (imageWidth == 0) {
                org.eclipse.swt.graphics.Image image = GraphitiUi.getImageService().getImageForId(imageId);
                imageWidth = image.getImageData().width;
            }
            return imageWidth;
        }
        return 0;
    }

    private static int getImageHeight(DiagramNodePart nodePart) {
        String imageId = nodePart.getImageId();
        if (imageId != null) {
            int imageHeight = nodePart.getImageHeight();
            if (imageHeight == 0) {
                org.eclipse.swt.graphics.Image image = GraphitiUi.getImageService().getImageForId(imageId);
                imageHeight = image.getImageData().height;
            }
            return imageHeight;
        }
        return 0;
    }
}

