/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.widgets.Display;

public final class DelayedTasksExecutor {
    private static final long DELAY = 300L;
    private static final long WORKER_THREAD_SHUTDOWN_DELAY = 600000L;
    private static final Task[] NO_TASKS = new Task[0];
    private static final TaskPriorityComparator TASK_PRIORITY_COMPARATOR = new TaskPriorityComparator();
    private static final Set<Task> tasks = new LinkedHashSet<Task>();
    private static long timeOfLastAddition = 0L;
    private static WorkerThread workerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Task task) {
        Set<Task> set = tasks;
        synchronized (set) {
            boolean taskScheduled = false;
            for (Task t : tasks) {
                if (t.subsumes(task)) {
                    taskScheduled = true;
                    break;
                }
                if (!task.subsumes(t)) continue;
                tasks.remove(t);
                break;
            }
            if (!taskScheduled) {
                tasks.add(task);
            }
            timeOfLastAddition = System.currentTimeMillis();
            if (workerThread == null || !workerThread.isAlive()) {
                workerThread = new WorkerThread();
                workerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Task[] getTasksToRun() {
        Set<Task> set = tasks;
        synchronized (set) {
            long now;
            long diff;
            Task[] result = NO_TASKS;
            if (!tasks.isEmpty() && (diff = (now = System.currentTimeMillis()) - timeOfLastAddition) >= 300L) {
                result = tasks.toArray(new Task[tasks.size()]);
                tasks.clear();
                timeOfLastAddition = 0L;
            }
            return result;
        }
    }

    public static abstract class Task
    implements Runnable {
        public int getPriority() {
            return 0;
        }

        public boolean subsumes(Task task) {
            return this.equals(task);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TaskPriorityComparator
    implements Comparator<Task> {
        private TaskPriorityComparator() {
        }

        @Override
        public int compare(Task t1, Task t2) {
            return t2.getPriority() - t1.getPriority();
        }
    }

    private static final class WorkerThread
    extends Thread {
        private long timeOfLastWork = System.currentTimeMillis();

        private WorkerThread() {
        }

        public void run() {
            while (true) {
                Task[] tasks;
                if ((tasks = DelayedTasksExecutor.getTasksToRun()).length > 0) {
                    final Task[] tasksToRun = tasks;
                    Arrays.sort(tasksToRun, TASK_PRIORITY_COMPARATOR);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            Task[] taskArray = tasksToRun;
                            int n = tasksToRun.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Task task = taskArray[n2];
                                try {
                                    task.run();
                                }
                                catch (Exception e) {
                                    SapphireUiFrameworkPlugin.log(e);
                                }
                                ++n2;
                            }
                        }
                    });
                    this.timeOfLastWork = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.timeOfLastWork >= 600000L) {
                    return;
                }
                try {
                    WorkerThread.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

