/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

public abstract class SapphireActionHandler
extends SapphireActionSystemPart {
    public static final String EVENT_PRE_EXECUTE = "pre-execute";
    public static final String EVENT_POST_EXECUTE = "post-execute";
    private SapphireAction action;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(def);
        this.action = action;
        if (this.getId() == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getName());
            buf.append('#');
            buf.append(System.identityHashCode(this));
            this.setId(buf.toString());
        }
        if (this.getLabel() == null) {
            this.setLabel(this.action.getLabel());
        }
    }

    public final SapphireAction getAction() {
        return this.action;
    }

    public final ISapphirePart getPart() {
        return this.action.getPart();
    }

    public final String getContext() {
        return this.action.getContext();
    }

    public final IModelElement getModelElement() {
        return this.getPart().getModelElement();
    }

    public final void execute(SapphireRenderingContext context) {
        if (this.getAction().getType() == SapphireActionType.TOGGLE) {
            this.setChecked(!this.isChecked());
        }
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_PRE_EXECUTE));
        Object result = null;
        try {
            result = this.run(context);
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        this.notifyListeners(new PostExecuteEvent(result));
    }

    protected abstract Object run(SapphireRenderingContext var1);

    public void dispose() {
    }

    public static class PostExecuteEvent
    extends SapphireActionSystemPart.Event {
        private final Object result;

        public PostExecuteEvent(Object result) {
            super(SapphireActionHandler.EVENT_POST_EXECUTE);
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

