/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationData;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.annotations.DocumentationProvider;
import org.eclipse.sapphire.modeling.annotations.DocumentationProviderImpl;
import org.eclipse.sapphire.modeling.annotations.DocumentationResource;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.internal.DocumentationUtil;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;

public class SapphireHelpContext
implements IContext,
IContext2 {
    private static final String LINE_BREAK = "[br/]";
    private String title = null;
    private String content = null;
    private final List<DocumentationResource> topics = new ArrayList<DocumentationResource>();

    public SapphireHelpContext(IModelElement modelElement, ModelProperty property) {
        this.title = property.getLabel(true, CapitalizationType.TITLE_STYLE, false);
        ModelProperty p = property;
        while (p != null) {
            DocumentationData data;
            Documentation documentation = (Documentation)p.getAnnotation(Documentation.class, true);
            DocumentationProvider documentationProvider = (DocumentationProvider)p.getAnnotation(DocumentationProvider.class, true);
            if (documentation != null) {
                this.initContext((ModelMetadataItem)p, p.getName(), documentation, null);
                if (documentation.mergeStrategy() == DocumentationMergeStrategy.REPLACE) {
                    break;
                }
            } else if (documentationProvider != null && (data = this.initContext(documentationProvider, null)) != null && data.getMergeStrategy() == DocumentationMergeStrategy.REPLACE) break;
            p = p.getBase();
        }
        ModelElementType type = modelElement.getModelElementType();
        Documentation typeDocumentation = (Documentation)type.getAnnotation(Documentation.class);
        DocumentationProvider typeDocumentationProvider = (DocumentationProvider)type.getAnnotation(DocumentationProvider.class);
        if (typeDocumentation != null) {
            this.initContext((ModelMetadataItem)type, "$contentHelp$", typeDocumentation, DocumentationMergeStrategy.APPEND);
        } else if (typeDocumentationProvider != null) {
            this.initContext(typeDocumentationProvider, DocumentationMergeStrategy.APPEND);
        }
        this.addGeneratedInformation(modelElement, property);
    }

    private void addGeneratedInformation(IModelElement modelElement, ModelProperty property) {
        ReadOnly readOnlyAnnotation;
        Required nonNullAnnotation;
        StringBuffer buffer = new StringBuffer();
        if (property instanceof ValueProperty) {
            NumericRange rangeAnnotation;
            ValueProperty valueProperty = (ValueProperty)property;
            String defaultValue = SapphireCommonUtil.getDefaultValueLabel((IModelElement)modelElement, (ValueProperty)valueProperty);
            if (defaultValue != null) {
                buffer.append(NLS.bind((String)Resources.defaultValueInfoMessage, (Object)defaultValue));
                buffer.append(LINE_BREAK);
            }
            if ((rangeAnnotation = (NumericRange)property.getAnnotation(NumericRange.class)) != null) {
                String min = rangeAnnotation.min();
                String max = rangeAnnotation.max();
                if (min != null && min.length() > 0) {
                    buffer.append(NLS.bind((String)Resources.minValueInfoMessage, (Object)SapphireCommonUtil.normalizeForDisplay((ValueProperty)valueProperty, (String)min)));
                    buffer.append(LINE_BREAK);
                }
                if (max != null && max.length() > 0) {
                    buffer.append(NLS.bind((String)Resources.maxValueInfoMessage, (Object)SapphireCommonUtil.normalizeForDisplay((ValueProperty)valueProperty, (String)max)));
                    buffer.append(LINE_BREAK);
                }
            }
        }
        if ((nonNullAnnotation = (Required)property.getAnnotation(Required.class)) != null) {
            buffer.append(NLS.bind((String)Resources.nonNullMessage, (Object)property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false)));
            buffer.append(LINE_BREAK);
        }
        if ((readOnlyAnnotation = (ReadOnly)property.getAnnotation(ReadOnly.class)) != null) {
            buffer.append(NLS.bind((String)Resources.readOnlyMessage, (Object)property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false)));
            buffer.append(LINE_BREAK);
        }
        if (buffer.length() > 0) {
            this.appendContent(buffer.toString());
        }
    }

    private void initContext(ModelMetadataItem property, String key, Documentation documentation, DocumentationMergeStrategy strategy) {
        if (strategy == null) {
            strategy = documentation.mergeStrategy();
        }
        LocalizationService localization = property.getLocalizationService();
        String res = localization.text(documentation.content(), CapitalizationType.NO_CAPS, false);
        if (strategy == DocumentationMergeStrategy.PREPEND) {
            this.prependContent(res);
        } else {
            this.appendContent(res);
        }
        ArrayList<DocumentationResource> topics = new ArrayList<DocumentationResource>();
        Documentation.Topic[] topicArray = documentation.topics();
        int n = topicArray.length;
        int n2 = 0;
        while (n2 < n) {
            Documentation.Topic topic = topicArray[n2];
            String label = localization.text(topic.label(), CapitalizationType.TITLE_STYLE, false);
            topics.add(new DocumentationResource(label, topic.href()));
            ++n2;
        }
        if (strategy == DocumentationMergeStrategy.PREPEND) {
            this.topics.addAll(0, topics);
        } else {
            this.topics.addAll(topics);
        }
    }

    private DocumentationData initContext(DocumentationProvider documentationProvider, DocumentationMergeStrategy strategy) {
        Class documentationProviderClass = documentationProvider.impl();
        try {
            DocumentationProviderImpl provider = (DocumentationProviderImpl)documentationProviderClass.newInstance();
            DocumentationData data = provider.getDocumentationData();
            if (data != null) {
                if (strategy == null) {
                    strategy = data.getMergeStrategy();
                }
                if (strategy == DocumentationMergeStrategy.PREPEND) {
                    this.prependContent(data.getContent());
                    this.topics.addAll(0, data.getTopics());
                } else {
                    this.appendContent(data.getContent());
                    this.topics.addAll(data.getTopics());
                }
                return data;
            }
        }
        catch (Exception e) {
            LoggingService.log((Exception)e);
        }
        return null;
    }

    private void appendContent(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        String decodedStr = DocumentationUtil.decodeDocumentationTags((String)str);
        if (this.content == null) {
            this.content = decodedStr;
        } else {
            StringBuffer buf = new StringBuffer(this.content);
            if (this.content.endsWith(DocumentationUtil.NEW_LINE)) {
                buf.append(DocumentationUtil.NEW_LINE);
            } else {
                buf.append(DocumentationUtil.NEW_LINE_2);
            }
            buf.append(decodedStr);
            this.content = buf.toString();
        }
    }

    private void prependContent(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        String decodedStr = DocumentationUtil.decodeDocumentationTags((String)str);
        if (this.content == null) {
            this.content = decodedStr;
        } else {
            StringBuffer buf = new StringBuffer(decodedStr);
            if (decodedStr.endsWith(DocumentationUtil.NEW_LINE)) {
                buf.append(DocumentationUtil.NEW_LINE);
            } else {
                buf.append(DocumentationUtil.NEW_LINE_2);
            }
            buf.append(this.content);
            this.content = buf.toString();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getStyledText() {
        return null;
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    public IHelpResource[] getRelatedTopics() {
        IHelpResource[] res = new IHelpResource[this.topics.size()];
        int i = 0;
        while (i < res.length) {
            final DocumentationResource resource = this.topics.get(i);
            res[i] = new IHelpResource(){

                public String getLabel() {
                    return resource.getLabel();
                }

                public String getHref() {
                    return resource.getUrl();
                }
            };
            ++i;
        }
        return res;
    }

    public String getText() {
        return this.content;
    }

    private static final class Resources
    extends NLS {
        public static String minValueInfoMessage;
        public static String maxValueInfoMessage;
        public static String defaultValueInfoMessage;
        public static String nonNullMessage;
        public static String readOnlyMessage;

        static {
            Resources.initializeMessages((String)SapphireHelpContext.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

