/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireIfElseDirectiveDef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireIfElseDirective
extends SapphirePart {
    private ISapphireIfElseDirectiveDef def;
    private SapphireCondition condition;
    private List<SapphirePart> thenContent;
    private List<SapphirePart> thenContentReadOnly;
    private List<SapphirePart> elseContent;
    private List<SapphirePart> elseContentReadOnly;

    @Override
    protected void init() {
        SapphirePart childPart;
        Class conditionClass;
        super.init();
        IModelElement modelElement = this.getModelElement();
        this.def = (ISapphireIfElseDirectiveDef)this.definition;
        Status conditionClassValidation = this.def.getConditionClass().validate();
        if (conditionClassValidation.severity() != Status.Severity.ERROR) {
            conditionClass = ((JavaType)this.def.getConditionClass().resolve()).artifact();
        } else {
            LoggingService.log((Status)conditionClassValidation);
            conditionClass = null;
        }
        if (conditionClass != null) {
            String conditionParameter = this.def.getConditionParameter().getText();
            this.condition = SapphireCondition.create(this, conditionClass, conditionParameter);
            if (this.condition != null) {
                this.condition.addListener(new SapphireCondition.Listener(){

                    public void handleConditionChanged() {
                        SapphireIfElseDirective.this.updateValidationState();
                        SapphireIfElseDirective.this.notifyStructureChangedEventListeners(new SapphirePartEvent(SapphireIfElseDirective.this));
                    }
                });
            }
        }
        this.thenContent = new ArrayList<SapphirePart>();
        this.thenContentReadOnly = Collections.unmodifiableList(this.thenContent);
        this.elseContent = new ArrayList<SapphirePart>();
        this.elseContentReadOnly = Collections.unmodifiableList(this.elseContent);
        SapphirePartListener childPartListener = new SapphirePartListener(){

            public void handleValidateStateChange(Status oldValidateState, Status newValidationState) {
                SapphireIfElseDirective.this.updateValidationState();
            }
        };
        for (ISapphirePartDef childPartDef : this.def.getThenContent()) {
            childPart = SapphireIfElseDirective.create(this, modelElement, childPartDef, this.params);
            this.thenContent.add(childPart);
            childPart.addListener(childPartListener);
        }
        for (ISapphirePartDef childPartDef : this.def.getElseContent()) {
            childPart = SapphireIfElseDirective.create(this, modelElement, childPartDef, this.params);
            this.elseContent.add(childPart);
            childPart.addListener(childPartListener);
        }
        this.updateValidationState();
    }

    public boolean getConditionState() {
        return this.condition != null ? this.condition.getConditionState() : false;
    }

    public List<SapphirePart> getThenContent() {
        return this.thenContentReadOnly;
    }

    public List<SapphirePart> getElseContent() {
        return this.elseContentReadOnly;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        if (this.condition != null) {
            for (SapphirePart child : this.condition.getConditionState() ? this.thenContent : this.elseContent) {
                child.render(context);
            }
        }
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        if (this.condition != null) {
            for (SapphirePart child : this.condition.getConditionState() ? this.thenContent : this.elseContent) {
                factory.add(child.getValidationState());
            }
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart child : this.thenContent) {
            child.dispose();
        }
        for (SapphirePart child : this.elseContent) {
            child.dispose();
        }
        if (this.condition != null) {
            this.condition.dispose();
        }
    }
}

