/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireSection
extends SapphireComposite {
    private ISapphireSectionDef definition;
    private SapphireCondition visibleWhenCondition;
    private Section section;
    private FunctionResult titleFunctionResult;

    @Override
    protected void init() {
        super.init();
        this.definition = (ISapphireSectionDef)((SapphireComposite)this).definition;
        this.visibleWhenCondition = null;
        JavaType visibleWhenConditionClass = (JavaType)this.definition.getVisibleWhenConditionClass().resolve();
        if (visibleWhenConditionClass != null) {
            String parameter = this.definition.getVisibleWhenConditionParameter().getText();
            this.visibleWhenCondition = SapphireCondition.create(this, visibleWhenConditionClass.artifact(), parameter);
        }
    }

    @Override
    protected Composite createOuterComposite(SapphireRenderingContext context) {
        FormToolkit toolkit = new FormToolkit(context.getDisplay());
        boolean collapsible = (Boolean)this.definition.getCollapsible().getContent();
        int style = 0x100 | (collapsible ? 2 : 0);
        this.section = toolkit.createSection(context.getComposite(), style);
        this.section.setLayoutData((Object)TableWrapLayoutUtil.twd());
        if (collapsible) {
            this.section.setExpanded((Boolean)this.definition.getCollapsedInitially().getContent() == false);
        }
        this.titleFunctionResult = this.initExpression(this.getModelElement(), (Function)this.definition.getLabel().getContent(), String.class, null, new Runnable(){

            public void run() {
                SapphireSection.this.refreshTitle();
            }
        });
        this.refreshTitle();
        Composite outerComposite = new Composite((Composite)this.section, 0);
        outerComposite.setLayout((Layout)TableWrapLayoutUtil.twlayout(1, 0, 0, 0, 0));
        context.adapt((Control)outerComposite);
        Composite innerComposite = new Composite(outerComposite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0, 0, 0));
        innerComposite.setLayoutData((Object)TableWrapLayoutUtil.twd());
        context.adapt((Control)innerComposite);
        SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        ToolBar toolbar = new ToolBar((Composite)this.section, 8519936);
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.section.setTextClient((Control)toolbar);
        toolkit.paintBordersFor((Composite)this.section);
        this.section.setClient((Control)outerComposite);
        return innerComposite;
    }

    private void refreshTitle() {
        String title = null;
        if (this.titleFunctionResult != null) {
            title = (String)this.titleFunctionResult.value();
        }
        if (title == null) {
            title = "#null#";
        } else {
            title = title.trim();
            title = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(title, CapitalizationType.TITLE_STYLE, false);
        }
        this.section.setText(title.trim());
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Section");
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                return SapphireHelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    public SapphireCondition getVisibleWhenCondition() {
        return this.visibleWhenCondition;
    }

    public boolean checkVisibleWhenCondition() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.visibleWhenCondition != null) {
            this.visibleWhenCondition.dispose();
        }
    }
}

