/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardPageDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireWizardPart
extends SapphirePart {
    private FunctionResult imageFunctionResult;
    private List<SapphireWizardPagePart> pages;
    private List<SapphireWizardPagePart> pagesReadOnly;

    @Override
    protected void init() {
        super.init();
        IModelElement element = this.getModelElement();
        ISapphireWizardDef def = this.getDefinition();
        this.imageFunctionResult = this.initExpression(element, (Function)def.getImage().getContent(), ImageData.class, null, new Runnable(){

            public void run() {
                SapphireWizardPart.this.notifyListeners(new SapphirePart.ImageChangedEvent(SapphireWizardPart.this));
            }
        });
        this.pages = new ArrayList<SapphireWizardPagePart>();
        this.pagesReadOnly = Collections.unmodifiableList(this.pages);
        for (ISapphireWizardPageDef pageDef : def.getPages()) {
            SapphireWizardPagePart pagePart = (SapphireWizardPagePart)SapphirePart.create(null, element, pageDef, this.params);
            this.pages.add(pagePart);
        }
    }

    @Override
    public ISapphireWizardDef getDefinition() {
        return (ISapphireWizardDef)super.getDefinition();
    }

    public String getLabel() {
        return this.getDefinition().getLabel().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
    }

    public String getDescription() {
        return this.getDefinition().getDescription().getLocalizedText(CapitalizationType.NO_CAPS, false);
    }

    public ImageData getImage() {
        return (ImageData)this.imageFunctionResult.value();
    }

    public List<SapphireWizardPagePart> getPages() {
        return this.pagesReadOnly;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.imageFunctionResult != null) {
            this.imageFunctionResult.dispose();
        }
    }
}

