/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class DefaultValueInfoAssistContributor
extends PropertyEditorAssistContributor {
    public DefaultValueInfoAssistContributor() {
        this.setId("System.DefaultValueContributor");
        this.setPriority(110);
    }

    public void contribute(PropertyEditorAssistContext context) {
        ValueProperty valprop;
        String defaultValue;
        IModelElement element = context.getModelElement();
        ModelProperty property = context.getProperty();
        if (property instanceof ValueProperty && element.read((ValueProperty)property).getText(false) != null && (defaultValue = SapphireCommonUtil.getDefaultValueLabel((IModelElement)element, (ValueProperty)(valprop = (ValueProperty)property))) != null) {
            String label = NLS.bind((String)Resources.defaultValueInfoMessage, (Object)defaultValue);
            label = "<p>" + DefaultValueInfoAssistContributor.escapeForXml(label) + "</p>";
            PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
            contribution.setText(label);
            PropertyEditorAssistSection section = context.getSection("info");
            section.addContribution(contribution);
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultValueInfoMessage;

        static {
            Resources.initializeMessages((String)DefaultValueInfoAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

