/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.def.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramImageChoice
extends ModelElement
implements IDiagramImageChoice {
    private Value<String> imageId;
    private Value<String> imagePath;

    public DiagramImageChoice(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DiagramImageChoice(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getImageId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.imageId == null) {
                this.refresh((ModelProperty)PROP_IMAGE_ID, true);
            }
            return this.imageId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImageId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_IMAGE_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_IMAGE_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_IMAGE_ID, true);
            if (!DiagramImageChoice.equal((String)this.imageId.getText(false), (String)value)) {
                this.resource().binding(PROP_IMAGE_ID).write(value);
                this.refresh((ModelProperty)PROP_IMAGE_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getImagePath() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.imagePath == null) {
                this.refresh((ModelProperty)PROP_IMAGE_PATH, true);
            }
            return this.imagePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImagePath(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_IMAGE_PATH.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_IMAGE_PATH, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_IMAGE_PATH, true);
            if (!DiagramImageChoice.equal((String)this.imagePath.getText(false), (String)value)) {
                this.resource().binding(PROP_IMAGE_PATH).write(value);
                this.refresh((ModelProperty)PROP_IMAGE_PATH, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_IMAGE_ID) {
                if (this.imageId != null || force) {
                    Value<String> oldValue = this.imageId;
                    String val = this.resource().binding(PROP_IMAGE_ID).read();
                    this.imageId = new Value((IModelElement)this, PROP_IMAGE_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_IMAGE_ID, ValueNormalizationService.class)).normalize(PROP_IMAGE_ID.encodeKeywords(val)));
                    this.imageId.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMAGE_ID);
                    if (oldValue != null) {
                        if (this.imageId.equals(oldValue)) {
                            this.imageId = oldValue;
                        }
                        if (this.imageId != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_IMAGE_ID, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_IMAGE_PATH && (this.imagePath != null || force)) {
                Value<String> oldValue = this.imagePath;
                String val = this.resource().binding(PROP_IMAGE_PATH).read();
                this.imagePath = new Value((IModelElement)this, PROP_IMAGE_PATH, ((ValueNormalizationService)this.service((ModelProperty)PROP_IMAGE_PATH, ValueNormalizationService.class)).normalize(PROP_IMAGE_PATH.encodeKeywords(val)));
                this.imagePath.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMAGE_PATH);
                if (oldValue != null) {
                    if (this.imagePath.equals(oldValue)) {
                        this.imagePath = oldValue;
                    }
                    if (this.imagePath != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_IMAGE_PATH, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_IMAGE_ID) {
            return this.getImageId();
        }
        if (property == PROP_IMAGE_PATH) {
            return this.getImagePath();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_IMAGE_ID) {
            this.setImageId((String)value);
            return;
        }
        if (property == PROP_IMAGE_PATH) {
            this.setImagePath((String)value);
            return;
        }
        super.write(property, value);
    }
}

