/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DiagramEmbeddedConnectionPart
extends DiagramConnectionPart {
    private IModelElement srcNodeModel;
    private IModelElement endpointModel;
    private ModelPath endpointPath;
    private FunctionResult endpointFunctionResult;
    private IDiagramConnectionEndpointBindingDef endpointDef;

    public DiagramEmbeddedConnectionPart(IDiagramExplicitConnectionBindingDef connBindingDef, IModelElement srcNodeModel, ModelPath endpointPath) {
        this.bindingDef = connBindingDef;
        this.srcNodeModel = srcNodeModel;
        this.endpointPath = endpointPath;
    }

    protected void init() {
        this.initLabelId();
        this.endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        if (this.endpointModel != null) {
            this.endpointFunctionResult = this.initExpression(this.endpointModel, (Function)this.endpointDef.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
        this.modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                DiagramEmbeddedConnectionPart.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    public IModelElement getEndpoint1() {
        return this.srcNodeModel;
    }

    public IModelElement getEndpoint2() {
        return this.endpointModel;
    }

    public void resetEndpoint1() {
    }

    public void resetEndpoint2() {
        if (this.endpointFunctionResult != null) {
            SapphireDiagramEditorPagePart diagramPart;
            DiagramNodePart nodePart;
            String value = (String)this.endpointFunctionResult.value();
            if ((value == null || value.length() == 0) && (nodePart = (diagramPart = this.getDiagramConnectionTemplate().getDiagramEditor()).getDiagramNodePart(this.endpointModel)) != null) {
                value = IdUtil.computeNodeId(nodePart);
            }
            String property = (String)this.endpointDef.getProperty().getContent();
            this.setModelProperty(this.modelElement, property, (Object)value);
        }
    }

    public DiagramNodePart getSourceNodePart() {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.getParentPart().getParentPart().getParentPart();
        return diagramPart.getDiagramNodePart(this.srcNodeModel);
    }

    public void dispose() {
        super.dispose();
        if (this.endpointFunctionResult != null) {
            this.endpointFunctionResult.dispose();
        }
    }

    public void addModelListener() {
        if (this.labelProperty != null) {
            this.modelElement.addListener(this.modelPropertyListener, this.labelProperty.getName());
        }
        this.modelElement.addListener(this.modelPropertyListener, (String)this.endpointDef.getProperty().getContent());
    }

    public void removeModelListener() {
        if (this.labelProperty != null) {
            this.modelElement.removeListener(this.modelPropertyListener, this.labelProperty.getName());
        }
        this.modelElement.removeListener(this.modelPropertyListener, (String)this.endpointDef.getProperty().getContent());
    }

    protected void handleModelPropertyChange(ModelPropertyChangeEvent event) {
        ModelProperty property = event.getProperty();
        if (property.getName().equals(this.endpointDef.getProperty().getContent())) {
            this.handleEndpointChange();
            this.notifyConnectionEndpointUpdate();
        }
    }

    private void handleEndpointChange() {
        this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        if (this.endpointFunctionResult != null) {
            this.endpointFunctionResult.dispose();
            this.endpointFunctionResult = null;
        }
        if (this.endpointModel != null) {
            this.endpointFunctionResult = this.initExpression(this.endpointModel, (Function)this.endpointDef.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
    }
}

