/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;

public class ModelUtil {
    public static ModelProperty resolve(IModelElement modelElement, String propertyName) {
        if (propertyName != null) {
            ModelElementType type = modelElement.getModelElementType();
            ModelProperty property = type.getProperty(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            return property;
        }
        return null;
    }

    public static ModelProperty resolve(ModelElementType modelElementType, ModelPath path) {
        if (path.length() == 1) {
            String propertyName = ((ModelPath.PropertySegment)path.head()).getPropertyName();
            ModelProperty modelProperty = modelElementType.getProperty(propertyName);
            return modelProperty;
        }
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment) {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            ModelProperty property = modelElementType.getProperty(propertyName);
            if (property instanceof ListProperty) {
                ModelElementType type = ((ListProperty)property).getType();
                return ModelUtil.resolve(type, path.tail());
            }
            throw new RuntimeException("Invalid model path <" + path + "> in ModelElementType " + modelElementType.getSimpleName());
        }
        throw new RuntimeException("Invalid model path <" + path + "> in ModelElementType " + modelElementType.getSimpleName());
    }

    public static ModelProperty resolve(IModelElement modelElement, ModelPath path) {
        if (path.length() == 1) {
            String propertyName = ((ModelPath.PropertySegment)path.head()).getPropertyName();
            return ModelUtil.resolve(modelElement, propertyName);
        }
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment) {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            ModelProperty property = modelElement.getModelElementType().getProperty(propertyName);
            if (property instanceof ListProperty) {
                ModelElementType type = ((ListProperty)property).getType();
                return ModelUtil.resolve(type, path.tail());
            }
            throw new RuntimeException("Invalid model path <" + path + "> in model element " + modelElement);
        }
        if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = modelElement.parent();
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            return ModelUtil.resolve((IModelElement)parent, path.tail());
        }
        throw new RuntimeException("Invalid model path <" + path + "> in model element " + modelElement);
    }
}

