/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.IContentOutlineNodeState;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.IMasterDetailsEditorPageState;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentOutline {
    private final MasterDetailsEditorPagePart editorPagePart;
    private final IMasterDetailsEditorPageDef editorPageDef;
    private final IModelElement rootModelElement;
    private MasterDetailsContentNode root;
    private List<MasterDetailsContentNode> selection;
    private final Set<Listener> listeners;
    private String filterText;

    public MasterDetailsContentOutline(MasterDetailsEditorPagePart editorPagePart) {
        this.editorPagePart = editorPagePart;
        this.editorPageDef = editorPagePart.getDefinition();
        this.rootModelElement = editorPagePart.getModelElement();
        this.selection = Collections.emptyList();
        this.listeners = new CopyOnWriteArraySet<Listener>();
        this.filterText = "";
    }

    public MasterDetailsContentNode getRoot() {
        if (this.root == null) {
            IMasterDetailsContentNodeDef rootNodeDef = this.editorPageDef.getRootNode();
            this.root = new MasterDetailsContentNode();
            this.root.init(this.editorPagePart, this.rootModelElement, rootNodeDef, Collections.<String, String>emptyMap());
            this.loadTreeState();
            this.addListener(new Listener(){

                @Override
                public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
                    MasterDetailsContentOutline.this.saveTreeState();
                }

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> newSelection) {
                    MasterDetailsContentOutline.this.saveTreeState();
                }

                @Override
                public void handleNodeStructureChange(MasterDetailsContentNode node) {
                    MasterDetailsContentOutline.this.handleNodeStructureChange();
                }
            });
        }
        return this.root;
    }

    public MasterDetailsContentNode getSelectedNode() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public List<MasterDetailsContentNode> getSelectedNodes() {
        return this.selection;
    }

    public void setSelectedNode(MasterDetailsContentNode selection) {
        if (selection == null) {
            this.setSelectedNodes(Collections.<MasterDetailsContentNode>emptyList());
        } else {
            this.setSelectedNodes(Collections.singletonList(selection));
        }
    }

    public void setSelectedNodes(List<MasterDetailsContentNode> selection) {
        if (!this.selection.equals(selection)) {
            for (MasterDetailsContentNode node : selection) {
                MasterDetailsContentNode parent = node.getParentNode();
                if (parent == null) continue;
                parent.setExpanded(true);
            }
            this.selection = selection.isEmpty() ? Collections.emptyList() : new ArrayList<MasterDetailsContentNode>(selection);
            this.notifyOfSelectionChange(this.selection);
        }
    }

    public void setSelection(String path) {
        MasterDetailsContentNode node = this.root;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            boolean segmentMatched = false;
            for (MasterDetailsContentNode n3 : node.getChildNodes()) {
                if (!n3.getLabel().equals(segment)) continue;
                node = n3;
                segmentMatched = true;
                break;
            }
            if (!segmentMatched) break;
            ++n2;
        }
        if (node != this.root) {
            this.setSelectedNode(node);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            node.getExpandedNodes(result);
        }
        return result;
    }

    public void setExpandedNodes(Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            MasterDetailsContentOutline.setExpandedNodes(node, expandedNodes);
        }
    }

    private static void setExpandedNodes(MasterDetailsContentNode node, Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode child : node.getChildNodes()) {
            MasterDetailsContentOutline.setExpandedNodes(child, expandedNodes);
        }
        boolean shouldBeExpanded = expandedNodes.contains(node);
        if (node.isExpanded() != shouldBeExpanded) {
            node.setExpanded(shouldBeExpanded);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        if (!this.filterText.equals(filterText)) {
            this.filterText = filterText;
            this.notifyOfFilterChange(filterText);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyOfNodeUpdate(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeUpdate(node);
        }
        MasterDetailsContentNode parent = node.getParentNode();
        if (parent != null) {
            this.notifyOfNodeUpdate(parent);
        }
    }

    public void notifyOfNodeStructureChange(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeStructureChange(node);
        }
    }

    public void notifyOfNodeExpandedStateChange(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeExpandedStateChange(node);
        }
    }

    public void notifyOfSelectionChange(List<MasterDetailsContentNode> newSelection) {
        for (Listener listener : this.listeners) {
            listener.handleSelectionChange(newSelection);
        }
    }

    private void notifyOfFilterChange(String newFilterText) {
        for (Listener listener : this.listeners) {
            listener.handleFilterChange(newFilterText);
        }
    }

    public void refresh() {
        this.notifyOfNodeStructureChange(null);
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    private void handleNodeStructureChange() {
        ArrayList<MasterDetailsContentNode> newSelection = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.selection) {
            LinkedList<MasterDetailsContentNode> path = new LinkedList<MasterDetailsContentNode>();
            while (node != this.root) {
                path.addFirst(node);
                node = node.getParentNode();
            }
            node = this.root;
            for (MasterDetailsContentNode n : path) {
                if (!node.getChildNodes().contains(n)) break;
                node = n;
            }
            if (node == this.root) {
                List<MasterDetailsContentNode> topLevelNodes = this.root.getChildNodes();
                node = topLevelNodes.size() > 0 ? topLevelNodes.get(0) : null;
            }
            if (newSelection.contains(node)) continue;
            newSelection.add(node);
        }
        this.setSelectedNodes(newSelection);
    }

    private void loadTreeState() {
        ArrayList<MasterDetailsContentNode> selection = new ArrayList<MasterDetailsContentNode>();
        IMasterDetailsEditorPageState editorPageState = this.editorPagePart.getState();
        if (editorPageState != null) {
            IContentOutlineNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                this.loadTreeState(rootNodeState, node, selection);
            }
        }
        if (!selection.isEmpty()) {
            this.setSelectedNodes(selection);
        } else {
            MasterDetailsContentNode node = this.root;
            String defaultInitialNodePath = this.editorPageDef.getInitialSelectionPath().getText();
            if (defaultInitialNodePath != null) {
                String[] stringArray = defaultInitialNodePath.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if ((node = node.getChildNodeByLabel(segment)) == null) break;
                    node.setExpanded(true);
                    ++n2;
                }
            }
            if (node != null) {
                this.setSelectedNode(node);
            }
        }
    }

    private void loadTreeState(IContentOutlineNodeState parentNodeState, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) {
        String nodeLabel = node.getLabel();
        for (IContentOutlineNodeState childNodeState : parentNodeState.getChildren()) {
            if (!nodeLabel.equals(childNodeState.getLabel().getText())) continue;
            node.setExpanded((Boolean)childNodeState.getExpanded().getContent());
            if (((Boolean)childNodeState.getSelected().getContent()).booleanValue()) {
                selection.add(node);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.loadTreeState(childNodeState, child, selection);
            }
        }
    }

    private void saveTreeState() {
        IMasterDetailsEditorPageState editorPageState = this.editorPagePart.getState();
        if (editorPageState != null) {
            IContentOutlineNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            rootNodeState.getChildren().clear();
            List<MasterDetailsContentNode> selection = this.getSelectedNodes();
            for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                this.saveTreeState(rootNodeState, node, selection);
            }
            try {
                rootNodeState.resource().save();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private void saveTreeState(IContentOutlineNodeState parentNodeState, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) {
        boolean isExpanded = node.isExpanded();
        boolean isSelected = selection.contains(node);
        if (isExpanded || isSelected) {
            IContentOutlineNodeState childNodeState = (IContentOutlineNodeState)parentNodeState.getChildren().addNewElement();
            childNodeState.setLabel(node.getLabel());
            if (isExpanded) {
                childNodeState.setExpanded(isExpanded);
            }
            if (isSelected) {
                childNodeState.setSelected(isSelected);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.saveTreeState(childNodeState, child, selection);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener {
        public void handleNodeUpdate(MasterDetailsContentNode node) {
        }

        public void handleNodeStructureChange(MasterDetailsContentNode node) {
        }

        public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
        }

        public void handleSelectionChange(List<MasterDetailsContentNode> newSelection) {
        }

        public void handleFilterChange(String newFilterText) {
        }
    }
}

