/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlineNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public static final String ID_BASE = "Sapphire.Add.";

    @Override
    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        for (ModelProperty property : node.getChildNodeFactoryProperties()) {
            AbstractActionHandler handler;
            ListProperty prop;
            if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                for (ModelElementType memberType : prop.getAllPossibleTypes()) {
                    handler = new ListPropertyActionHandler(prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                prop = (ElementProperty)property;
                for (ModelElementType memberType : prop.getAllPossibleTypes()) {
                    handler = new ElementPropertyActionHandler((ElementProperty)prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return handlers;
    }

    private static abstract class AbstractActionHandler
    extends SapphireActionHandler {
        private final ModelProperty property;
        private final ModelElementType type;
        private MasterDetailsContentOutline contentTree;
        private MasterDetailsContentOutline.Listener contentTreeListener;

        public AbstractActionHandler(ModelProperty property, ModelElementType type) {
            this.property = property;
            this.type = type;
            this.setId(OutlineNodeAddActionHandlerFactory.ID_BASE + type.getSimpleName());
            this.setLabel(type.getLabel(true, CapitalizationType.NO_CAPS, false));
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            ImageDescriptor typeSpecificAddImage = SwtRendererUtil.toImageDescriptor(this.type.image());
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.contentTree = ((MasterDetailsContentNode)this.getPart()).getContentTree();
            this.contentTreeListener = new MasterDetailsContentOutline.Listener(){

                public void handleFilterChange(String newFilterText) {
                    AbstractActionHandler.this.refreshEnablementState();
                }
            };
            this.contentTree.addListener(this.contentTreeListener);
            this.refreshEnablementState();
        }

        protected final void refreshEnablementState() {
            this.setEnabled(this.computeEnablementState());
        }

        protected boolean computeEnablementState() {
            return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
        }

        public ModelProperty property() {
            return this.property;
        }

        protected final Object run(SapphireRenderingContext context) {
            IModelElement newModelElement;
            MasterDetailsContentNode node;
            block4: {
                node = (MasterDetailsContentNode)this.getPart();
                IModelElement element = node.getLocalModelElement();
                newModelElement = null;
                try {
                    newModelElement = this.create(element, this.property, this.type);
                }
                catch (Exception e) {
                    EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                    if (editFailedException != null) break block4;
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (newModelElement != null) {
                node.getContentTree().notifyOfNodeStructureChange(node);
                for (MasterDetailsContentNode n : node.getChildNodes()) {
                    if (n.getModelElement() != newModelElement) continue;
                    n.select();
                    this.getPart().nearest(MasterDetailsEditorPagePart.class).setFocusOnDetails();
                    break;
                }
            }
            return newModelElement;
        }

        protected abstract IModelElement create(IModelElement var1, ModelProperty var2, ModelElementType var3);

        public void dispose() {
            super.dispose();
            if (this.contentTree != null) {
                this.contentTree.removeListener(this.contentTreeListener);
            }
        }
    }

    private static final class ElementPropertyActionHandler
    extends AbstractActionHandler {
        private ModelPropertyListener listener;

        public ElementPropertyActionHandler(ElementProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            this.listener = new ModelPropertyListener(){

                public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                    ElementPropertyActionHandler.this.refreshEnablementState();
                }
            };
            IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
            element.addListener(this.listener, this.property().getName());
        }

        public ElementProperty property() {
            return (ElementProperty)super.property();
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ElementProperty)property).element(true, type);
        }

        protected boolean computeEnablementState() {
            boolean state = super.computeEnablementState();
            if (state) {
                IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
                ModelElementHandle handle = element.read(this.property());
                state = handle.element() == null;
            }
            return state;
        }

        public void dispose() {
            super.dispose();
            if (this.listener != null) {
                IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
                element.removeListener(this.listener, this.property().getName());
            }
        }
    }

    private static final class ListPropertyActionHandler
    extends AbstractActionHandler {
        public ListPropertyActionHandler(ListProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ListProperty)property).addNewElement(type);
        }
    }
}

