/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.binding.ComboBinding;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroupBinding;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class EnumPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Control control;

    public EnumPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        RadioButtonsGroup buttonsGroup;
        Composite composite;
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean showLabel = part.getRenderingHint("show.label", true);
        int baseIndent = part.getLeftMarginHint();
        boolean preferVerticalRadioButtonBinding = part.getRenderingHint("prefer.vertical.radio.buttons", false);
        boolean preferRadioButtonBinding = part.getRenderingHint("prefer.radio.buttons", false);
        boolean preferComboBinding = part.getRenderingHint("prefer.combo", false);
        int hspan = showLabel && !preferVerticalRadioButtonBinding ? 1 : 2;
        Enum[] enumValues = (Enum[])property.getTypeClass().getEnumConstants();
        Label labelControl = null;
        PropertyEditorAssistDecorator decorator = null;
        if (showLabel) {
            String labelText = property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true);
            if (preferVerticalRadioButtonBinding) {
                composite = this.createMainComposite(parent);
                composite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), hspan));
                composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
                this.context.adapt((Control)composite);
                decorator = this.createDecorator(composite);
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
                Label label = new Label(composite, 64);
                label.setLayoutData((Object)GridLayoutUtil.gd());
                label.setText(labelText);
                labelControl = label;
                decorator.addEditorControl((Control)composite);
                decorator.addEditorControl((Control)label);
            } else {
                Label label = new Label(parent, 0);
                label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gd(), baseIndent + 9));
                label.setText(String.valueOf(labelText) + ":");
                this.context.adapt((Control)label);
                labelControl = label;
            }
        }
        if (preferVerticalRadioButtonBinding) {
            Composite p = parent;
            if (!showLabel) {
                composite = new Composite(p, 0);
                composite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2));
                composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
                this.context.adapt((Control)composite);
                decorator = this.createDecorator(composite);
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), 4));
                decorator.addEditorControl((Control)composite);
                p = composite;
            }
            buttonsGroup = new RadioButtonsGroup(this.context, p, true);
            if (showLabel) {
                buttonsGroup.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), hspan), baseIndent + 20));
            } else {
                buttonsGroup.setLayoutData(GridLayoutUtil.gdhfill());
            }
            this.context.adapt((Control)buttonsGroup);
            this.control = buttonsGroup;
        } else {
            Composite composite2 = this.createMainComposite(parent);
            composite2.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            this.context.adapt((Control)composite2);
            decorator = this.createDecorator(composite2);
            decorator.addEditorControl((Control)composite2);
            if (preferRadioButtonBinding || enumValues.length <= 3 && !preferComboBinding) {
                composite2.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), hspan));
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
                buttonsGroup = new RadioButtonsGroup(this.context, composite2, false);
                buttonsGroup.setLayoutData(GridLayoutUtil.gdhfill());
                this.context.adapt((Control)buttonsGroup);
                this.control = buttonsGroup;
            } else {
                int whint = part.getRenderingHint("width", -1);
                composite2.setLayoutData((Object)GridLayoutUtil.gdhspan(whint == -1 ? GridLayoutUtil.gdhfill() : GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), whint), hspan));
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
                Combo c = new Combo(composite2, 2060);
                c.setLayoutData((Object)GridLayoutUtil.gdhfill());
                c.setVisibleItemCount(10);
                this.context.adapt((Control)c);
                this.control = c;
            }
        }
        if (labelControl != null) {
            this.control.setData("related-controls", labelControl);
        }
        this.binding = this.control instanceof RadioButtonsGroup ? new RadioButtonsGroupBinding(this.getPart(), this.context, (RadioButtonsGroup)this.control) : new ComboBinding(this.getPart(), this.context, (Combo)this.control);
        this.control.setData("binding", (Object)this.binding);
        decorator.addEditorControl(this.control, true);
        this.addControl(this.control);
    }

    protected void handleFocusReceivedEvent() {
        this.control.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.isOfType(Enum.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new EnumPropertyEditorRenderer(context, part);
        }
    }
}

