/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.SortedSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.services.PossibleTypesService;

public final class StandardXmlElementBindingImpl
extends LayeredElementBindingImpl {
    private PossibleTypesService possibleTypesService;
    private Listener possibleTypesServiceListener;
    private XmlPath path;
    private QName[] xmlElementNames;
    private ModelElementType[] modelElementTypes;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.possibleTypesService = (PossibleTypesService)element.service(property, PossibleTypesService.class);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                StandardXmlElementBindingImpl.this.initBindingMetadata();
            }
        };
        this.possibleTypesService.attach(this.possibleTypesServiceListener);
        this.initBindingMetadata();
    }

    private void initBindingMetadata() {
        IModelElement element = this.element();
        ElementProperty property = this.property();
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)element.resource()).getXmlNamespaceResolver();
            SortedSet possible = this.possibleTypesService.types();
            this.modelElementTypes = possible.toArray(new ModelElementType[possible.size()]);
            if (xmlElementBindingAnnotation == null) {
                XmlBinding xmlBindingAnnotation = (XmlBinding)property.getAnnotation(XmlBinding.class);
                if (xmlBindingAnnotation != null && possible.size() == 1) {
                    String path = xmlBindingAnnotation.path();
                    int slashIndex = path.lastIndexOf(47);
                    if (slashIndex == -1) {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path, xmlNamespaceResolver)};
                    } else if (slashIndex > 0 && slashIndex < path.length() - 1) {
                        this.path = new XmlPath(path.substring(0, slashIndex), xmlNamespaceResolver);
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName(path.substring(slashIndex + 1), xmlNamespaceResolver)};
                    }
                }
                if (this.xmlElementNames == null) {
                    this.path = new XmlPath(property.getName(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
                    this.xmlElementNames = new QName[this.modelElementTypes.length];
                    int i = 0;
                    while (i < this.modelElementTypes.length) {
                        this.xmlElementNames[i] = this.createDefaultElementName(this.modelElementTypes[i], xmlNamespaceResolver);
                        ++i;
                    }
                }
            } else {
                if (xmlElementBindingAnnotation.path().length() > 0) {
                    this.path = new XmlPath(xmlElementBindingAnnotation.path(), xmlNamespaceResolver);
                }
                XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
                this.xmlElementNames = new QName[this.modelElementTypes.length];
                int i = 0;
                while (i < this.modelElementTypes.length) {
                    ModelElementType type = this.modelElementTypes[i];
                    XmlElementBinding.Mapping[] mappingArray = mappings;
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XmlElementBinding.Mapping mapping = mappingArray[n2];
                        if (mapping.type() == type.getModelElementClass()) {
                            String mappingElementName = mapping.element().trim();
                            if (mappingElementName.length() == 0) {
                                throw new RuntimeException(Resources.mustSpecifyElementNameMsg);
                            }
                            this.xmlElementNames[i] = XmlUtil.createQualifiedName(mappingElementName, xmlNamespaceResolver);
                            break;
                        }
                        ++n2;
                    }
                    if (this.xmlElementNames[i] == null) {
                        this.xmlElementNames[i] = this.createDefaultElementName(type, xmlNamespaceResolver);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failure, (Object[])new Object[]{element.getModelElementType().getSimpleName(), property.getName(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected QName createDefaultElementName(ModelElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName(type);
    }

    public ModelElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName(xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (XmlUtil.equal(this.xmlElementNames[i], xmlElementName, xmlElementNamespace)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (parent != null) {
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                    if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                    return element;
                }
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ModelElementType type) {
        QName xmlElementName;
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(true);
        if (this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, true);
        }
        if ((xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)]).getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    public void remove() {
        XmlElement base = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (base != null) {
            XmlElement parent = base;
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
                    if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
                    element.remove();
                }
                if (parent != base && parent.isEmpty()) {
                    base.removeChildNode(this.path);
                }
            }
        }
    }

    public boolean removable() {
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.possibleTypesService != null) {
            this.possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }

    private static final class Resources
    extends NLS {
        public static String failure;
        public static String mustSpecifyElementNameMsg;

        static {
            Resources.initializeMessages((String)StandardXmlElementBindingImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

