/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IContactsDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttendeeResource
extends Resource {
    private final org.eclipse.sapphire.samples.calendar.IAttendee base;
    private final IContactsDatabase contacts;
    private final ModelElementListener listener;

    public AttendeeResource(Resource parent, org.eclipse.sapphire.samples.calendar.IAttendee base) {
        super(parent);
        this.base = base;
        this.contacts = this.adapt(IContactsDatabase.class);
        this.listener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                ModelProperty property = event.getProperty();
                IModelElement element = AttendeeResource.this.element();
                if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_NAME) {
                    element.refresh((ModelProperty)IAttendee.PROP_NAME);
                    element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                    element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                } else if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_TYPE) {
                    element.refresh((ModelProperty)IAttendee.PROP_TYPE);
                } else if (property == IContactsDatabase.PROP_CONTACTS) {
                    element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                    element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                } else if (property == IContact.PROP_NAME) {
                    element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                    element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                } else if (property == IContact.PROP_E_MAIL) {
                    element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                }
            }
        };
        this.base.addListener(this.listener);
        this.contacts.addListener(this.listener);
    }

    public org.eclipse.sapphire.samples.calendar.IAttendee getBase() {
        return this.base;
    }

    protected BindingImpl createBinding(ModelProperty property) {
        if (property == IAttendee.PROP_NAME) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.getBase().getName().getText(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setName(value);
                }
            };
        }
        if (property == IAttendee.PROP_TYPE) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.getBase().getType().getText(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setType(value);
                }
            };
        }
        if (property == IAttendee.PROP_E_MAIL) {
            return new ValueBindingImpl(){

                public String read() {
                    IContact c = AttendeeResource.this.findContactRecord(false);
                    return c != null ? c.getEMail().getText() : null;
                }

                public void write(String value) {
                    IContact c = AttendeeResource.this.findContactRecord(value != null);
                    if (c != null) {
                        c.setEMail(value);
                    }
                }
            };
        }
        if (property == IAttendee.PROP_IN_CONTACTS_DATABASE) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.findContactRecord(false) != null ? Boolean.TRUE.toString() : null;
                }

                public void write(String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private IContact findContactRecord(boolean createIfNecessary) {
        IContact c = null;
        String name = this.base.getName().getText();
        if (name != null) {
            for (IContact contact : this.contacts.getContacts()) {
                if (!name.equals(contact.getName().getText())) continue;
                c = contact;
                break;
            }
            if (c == null && createIfNecessary) {
                c = (IContact)this.contacts.getContacts().addNewElement();
                c.setName(name);
            }
            for (IContact contact : this.contacts.getContacts()) {
                contact.addListener(this.listener);
            }
        }
        return c;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object res = super.adapt(adapterType);
        if (res == null) {
            res = this.base.adapt(adapterType);
        }
        return (A)res;
    }
}

