/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.po;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.samples.po.BillingInformation;
import org.eclipse.sapphire.samples.po.PurchaseOrderEntry;
import org.eclipse.sapphire.samples.po.ShippingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenerateImpl
public interface PurchaseOrder
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(PurchaseOrder.class);
    @Label(standard="ID")
    @Required
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");
    @Label(standard="customer")
    @Required
    public static final ValueProperty PROP_CUSTOMER = new ValueProperty(TYPE, "Customer");
    @Type(base=Date.class)
    @Label(standard="initial quote date")
    public static final ValueProperty PROP_INITIAL_QUOTE_DATE = new ValueProperty(TYPE, "InitialQuoteDate");
    @Type(base=Date.class)
    @Label(standard="order date")
    public static final ValueProperty PROP_ORDER_DATE = new ValueProperty(TYPE, "OrderDate");
    @Type(base=Date.class)
    @Label(standard="fulfillment date")
    public static final ValueProperty PROP_FULFILLMENT_DATE = new ValueProperty(TYPE, "FulfillmentDate");
    @Type(base=BillingInformation.class)
    @Label(standard="billing information")
    @XmlBinding(path="BillingInformation")
    public static final ImpliedElementProperty PROP_BILLING_INFORMATION = new ImpliedElementProperty(TYPE, "BillingInformation");
    @Type(base=ShippingInformation.class)
    @Label(standard="shipping information")
    @XmlBinding(path="ShippingInformation")
    public static final ImpliedElementProperty PROP_SHIPPING_INFORMATION = new ImpliedElementProperty(TYPE, "ShippingInformation");
    @Type(base=PurchaseOrderEntry.class)
    @Label(standard="entries")
    @CountConstraint(min=1)
    public static final ListProperty PROP_ENTRIES = new ListProperty(TYPE, "Entries");
    @Type(base=BigDecimal.class)
    @Label(standard="subtotal")
    @Derived(text="${ Sum( Entries, 'Total' ) }")
    public static final ValueProperty PROP_SUBTOTAL = new ValueProperty(TYPE, "Subtotal");
    @Type(base=BigDecimal.class)
    @Label(standard="discount")
    @DefaultValue(text="0.00")
    public static final ValueProperty PROP_DISCOUNT = new ValueProperty(TYPE, "Discount");
    @Type(base=BigDecimal.class)
    @Label(standard="delivery")
    @DefaultValue(text="0.00")
    public static final ValueProperty PROP_DELIVERY = new ValueProperty(TYPE, "Delivery");
    @Type(base=BigDecimal.class)
    @Label(standard="total")
    @Derived(text="${ Scale( Subtotal, 2 ) - Scale( Discount, 2 ) + Scale( Delivery, 2 ) }")
    public static final ValueProperty PROP_TOTAL = new ValueProperty(TYPE, "Total");

    public Value<String> getId();

    public void setId(String var1);

    public Value<String> getCustomer();

    public void setCustomer(String var1);

    public Value<Date> getInitialQuoteDate();

    public void setInitialQuoteDate(String var1);

    public void setInitialQuoteDate(Date var1);

    public Value<Date> getOrderDate();

    public void setOrderDate(String var1);

    public void setOrderDate(Date var1);

    public Value<Date> getFulfillmentDate();

    public void setFulfillmentDate(String var1);

    public void setFulfillmentDate(Date var1);

    public BillingInformation getBillingInformation();

    public ShippingInformation getShippingInformation();

    public ModelElementList<PurchaseOrderEntry> getEntries();

    public Value<BigDecimal> getSubtotal();

    public Value<BigDecimal> getDiscount();

    public void setDiscount(String var1);

    public void setDiscount(BigDecimal var1);

    public Value<BigDecimal> getDelivery();

    public void setDelivery(String var1);

    public void setDelivery(BigDecimal var1);

    public Value<BigDecimal> getTotal();
}

