/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.actions;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.SapphireDiagramActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireConnectionRouter;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramTypeProvider;

public abstract class DiagramGraphLayoutActionHandler
extends SapphireDiagramActionHandler {
    private static final int PADDING = 36;

    public boolean canExecute(Object obj) {
        return true;
    }

    public abstract int getGraphDirection();

    protected Object run(SapphireRenderingContext context) {
        DiagramRenderingContext diagramCtx = (DiagramRenderingContext)context;
        SapphireDiagramTypeProvider tp = (SapphireDiagramTypeProvider)diagramCtx.getDiagramEditor().getDiagramTypeProvider();
        SapphireDiagramFeatureProvider fp = (SapphireDiagramFeatureProvider)tp.getFeatureProvider();
        Diagram diagram = tp.getDiagram();
        CompoundDirectedGraph graph = this.mapDiagramToGraph(fp, diagram);
        graph.setDefaultPadding(new Insets(36));
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        this.mapGraphCoordinatesToDiagram(graph, fp, diagram);
        return null;
    }

    private CompoundDirectedGraph mapDiagramToGraph(SapphireDiagramFeatureProvider fp, Diagram d) {
        HashMap<Shape, Node> shapeToNode = new HashMap<Shape, Node>();
        CompoundDirectedGraph dg = new CompoundDirectedGraph();
        if (this.getGraphDirection() == 24) {
            dg.setDirection(this.getGraphDirection());
        }
        EdgeList edgeList = new EdgeList();
        NodeList nodeList = new NodeList();
        EList children = d.getChildren();
        for (Shape shape : children) {
            Node node = new Node();
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            node.x = ga.getX();
            node.y = ga.getY();
            node.width = ga.getWidth();
            node.height = ga.getHeight();
            node.data = shape;
            shapeToNode.put(shape, node);
            nodeList.add((Object)node);
        }
        EList connections = d.getConnections();
        for (Connection connection : connections) {
            AnchorContainer source = connection.getStart().getParent();
            AnchorContainer target = connection.getEnd().getParent();
            Edge edge = new Edge((Object)connection, (Node)shapeToNode.get(source), (Node)shapeToNode.get(target));
            edge.data = connection;
            edgeList.add((Object)edge);
        }
        dg.nodes = nodeList;
        dg.edges = edgeList;
        return dg;
    }

    private void mapGraphCoordinatesToDiagram(final CompoundDirectedGraph graph, final SapphireDiagramFeatureProvider fp, final Diagram diagram) {
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                DiagramGraphLayoutActionHandler.this.mapGraphNodeCoordinatesToDiagram(graph, fp);
                DiagramGraphLayoutActionHandler.this.removeDiagramManualBendpoints(fp, diagram);
                DiagramGraphLayoutActionHandler.this.mapGraphEdgeCoordinatesToDiagram(graph, fp);
            }
        });
    }

    private void mapGraphNodeCoordinatesToDiagram(CompoundDirectedGraph graph, SapphireDiagramFeatureProvider fp) {
        NodeList myNodes = new NodeList();
        myNodes.addAll((Collection)graph.nodes);
        myNodes.addAll((Collection)graph.subgraphs);
        for (Object object : myNodes) {
            Node node = (Node)object;
            Shape shape = (Shape)node.data;
            shape.getGraphicsAlgorithm().setX(node.x);
            shape.getGraphicsAlgorithm().setY(node.y);
            shape.getGraphicsAlgorithm().setWidth(node.width);
            shape.getGraphicsAlgorithm().setHeight(node.height);
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (!(bo instanceof DiagramNodePart)) continue;
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            nodePart.setNodePosition(node.x, node.y);
        }
    }

    private void removeDiagramManualBendpoints(SapphireDiagramFeatureProvider fp, Diagram d) {
        EList cons = d.getConnections();
        for (Connection conn : cons) {
            if (!(conn instanceof FreeFormConnection)) continue;
            FreeFormConnection freeConn = (FreeFormConnection)conn;
            freeConn.getBendpoints().clear();
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof DiagramConnectionPart)) continue;
            DiagramConnectionPart connPart = (DiagramConnectionPart)bo;
            connPart.removeAllBendpoints();
        }
    }

    private void mapGraphEdgeCoordinatesToDiagram(CompoundDirectedGraph graph, SapphireDiagramFeatureProvider fp) {
        EdgeList myEdges = new EdgeList();
        myEdges.addAll((Collection)graph.edges);
        for (Object object : myEdges) {
            Point bendPoint;
            Edge edge = (Edge)object;
            Connection conn = (Connection)edge.data;
            NodeList nodes = edge.vNodes;
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            DiagramConnectionPart connPart = (DiagramConnectionPart)bo;
            if (conn instanceof FreeFormConnection && nodes != null) {
                FreeFormConnection freeConn = (FreeFormConnection)conn;
                int bpIndex = 0;
                int i = 0;
                while (i < nodes.size()) {
                    int offset;
                    Node vn = nodes.getNode(i);
                    int x = vn.x;
                    int y = vn.y;
                    if (this.getGraphDirection() == 24) {
                        offset = edge.isFeedback() ? -vn.width : vn.width;
                        freeConn.getBendpoints().add(bpIndex, (Object)Graphiti.getGaCreateService().createPoint(x, y));
                        freeConn.getBendpoints().add(bpIndex + 1, (Object)Graphiti.getGaCreateService().createPoint(x + offset, y));
                        connPart.addBendpoint(bpIndex, x, y);
                        connPart.addBendpoint(bpIndex + 1, x + offset, y);
                    } else {
                        offset = edge.isFeedback() ? -vn.height : vn.height;
                        freeConn.getBendpoints().add(bpIndex, (Object)Graphiti.getGaCreateService().createPoint(x, y));
                        freeConn.getBendpoints().add(bpIndex + 1, (Object)Graphiti.getGaCreateService().createPoint(x, y + offset));
                        connPart.addBendpoint(bpIndex, x, y);
                        connPart.addBendpoint(bpIndex + 1, x, y + offset);
                    }
                    bpIndex += 2;
                    ++i;
                }
                continue;
            }
            if (!(conn instanceof FreeFormConnection) || (bendPoint = SapphireConnectionRouter.getInstance().route((FreeFormConnection)conn)) == null) continue;
            ((FreeFormConnection)conn).getBendpoints().add((Object)Graphiti.getCreateService().createPoint(bendPoint.x, bendPoint.y));
            connPart.addBendpoint(0, bendPoint.x, bendPoint.y);
        }
    }
}

