/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.internal.MultiValueMap;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;

public class SapphireConnectionRouter {
    private static SapphireConnectionRouter instance;
    private MultiValueMap connections = new MultiValueMap();
    private int separation = 30;

    private SapphireConnectionRouter() {
    }

    public static SapphireConnectionRouter getInstance() {
        if (instance == null) {
            instance = new SapphireConnectionRouter();
        }
        return instance;
    }

    public int getSeparation() {
        return this.separation;
    }

    public void setSeparation(int value) {
        this.separation = value;
    }

    public void removeConnectionFromCache(Connection conn) {
        HashKey connectionKey = new HashKey(conn);
        this.connections.remove((Object)connectionKey, (Object)conn);
    }

    public Point route(FreeFormConnection conn) {
        HashKey connectionKey = new HashKey((Connection)conn);
        ArrayList connectionList = this.connections.get((Object)connectionKey);
        if (connectionList != null) {
            int index;
            Anchor startAnchor = conn.getStart();
            ILayoutService layoutService = Graphiti.getLayoutService();
            ILocation startLocation = layoutService.getLocationRelativeToDiagram(startAnchor);
            Point startPoint = new Point(startLocation.getX(), startLocation.getY());
            Anchor endAnchor = conn.getEnd();
            ILocation endLocation = layoutService.getLocationRelativeToDiagram(endAnchor);
            Point endPoint = new Point(endLocation.getX(), endLocation.getY());
            PointList points = new PointList();
            points.addPoint(startPoint);
            points.addPoint(endPoint);
            if (connectionList.contains(conn)) {
                index = connectionList.indexOf(conn) + 1;
            } else {
                index = connectionList.size() + 1;
                this.connections.put((Object)connectionKey, (Object)conn);
            }
            Point bendpoint = this.handleCollision(points, index);
            return bendpoint;
        }
        this.connections.put((Object)connectionKey, (Object)conn);
        return null;
    }

    public void addConnection(FreeFormConnection conn) {
        HashKey connectionKey = new HashKey((Connection)conn);
        this.connections.put((Object)connectionKey, (Object)conn);
    }

    private Point handleCollision(PointList points, int index) {
        Point end;
        Point start = points.getFirstPoint();
        if (start.equals((Object)(end = points.getLastPoint()))) {
            return null;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        Ray ray = position == 4 || position == 16 ? new Ray(start, end) : new Ray(end, start);
        double length = ray.length();
        double xSeparation = (double)(this.getSeparation() * ray.x) / length;
        double ySeparation = (double)(this.getSeparation() * ray.y) / length;
        Point bendPoint = index % 2 == 0 ? new Point((double)midPoint.x + (double)(index / 2) * (-1.0 * ySeparation), (double)midPoint.y + (double)(index / 2) * xSeparation) : new Point((double)midPoint.x + (double)(index / 2) * ySeparation, (double)midPoint.y + (double)(index / 2) * (-1.0 * xSeparation));
        if (!bendPoint.equals((Object)midPoint)) {
            return bendPoint;
        }
        return null;
    }

    private class HashKey {
        private Anchor anchor1;
        private Anchor anchor2;

        HashKey(Connection conn) {
            this.anchor1 = conn.getStart();
            this.anchor2 = conn.getEnd();
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof HashKey) {
                HashKey hashKey = (HashKey)object;
                Anchor hkA1 = hashKey.getFirstAnchor();
                Anchor hkA2 = hashKey.getSecondAnchor();
                isEqual = hkA1.equals(this.anchor1) && hkA2.equals(this.anchor2) || hkA1.equals(this.anchor2) && hkA2.equals(this.anchor1);
            }
            return isEqual;
        }

        public Anchor getFirstAnchor() {
            return this.anchor1;
        }

        public Anchor getSecondAnchor() {
            return this.anchor2;
        }

        public int hashCode() {
            return this.anchor1.hashCode() ^ this.anchor2.hashCode();
        }
    }
}

