/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateFeature;

public class SapphireCreateNodeFeature
extends AbstractCreateFeature
implements SapphireCreateFeature {
    private DiagramNodeTemplate nodeTemplate;

    public SapphireCreateNodeFeature(IFeatureProvider fp, DiagramNodeTemplate nodeTemplate) {
        super(fp, nodeTemplate.getToolPaletteLabel(), nodeTemplate.getToolPaletteDesc());
        this.nodeTemplate = nodeTemplate;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        DiagramNodePart nodePart = this.nodeTemplate.createNewDiagramNode();
        nodePart.setNodePosition(context.getX(), context.getY());
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        return new Object[]{nodePart};
    }

    public String getCreateImageId() {
        IDiagramImageChoice image = this.nodeTemplate.getToolPaletteImage();
        if (image != null) {
            return (String)image.getImageId().getContent();
        }
        return super.getCreateImageId();
    }

    public IDiagramNodeDef getNodeDef() {
        return this.nodeTemplate.getDefinition();
    }

    public int compareTo(SapphireCreateFeature o) {
        if (!(o instanceof SapphireCreateNodeFeature) && !(o instanceof SapphireCreateConnectionFeature)) {
            throw new IllegalArgumentException();
        }
        String createName = this.getCreateName();
        String otherName = null;
        if (o instanceof SapphireCreateNodeFeature) {
            otherName = ((SapphireCreateNodeFeature)o).getCreateName();
        } else if (o instanceof SapphireCreateConnectionFeature) {
            otherName = ((SapphireCreateConnectionFeature)o).getCreateName();
        }
        return createName.compareTo(otherName);
    }

    public String getPaletteCompartmentId() {
        return (String)this.getNodeDef().getToolPaletteCompartment().getContent();
    }
}

