/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;

public class SapphireDeleteFeature
extends DefaultDeleteFeature {
    private static final String DELETE_ACTION_ID = "Sapphire.Delete";
    private boolean doneChanges = false;

    public SapphireDeleteFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canDelete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return !(bo instanceof DiagramImplicitConnectionPart);
    }

    public void delete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        this.setDoneChanges(true);
        this.preDelete(context);
        this.deleteBusinessObjects(businessObjectsForPictogramElement);
        this.postDelete(context);
    }

    protected void deleteBusinessObject(Object bo) {
        if (bo instanceof ISapphirePart) {
            ISapphirePart part = (ISapphirePart)bo;
            DiagramRenderingContext sapphireContext = ((SapphireDiagramFeatureProvider)this.getFeatureProvider()).getRenderingContext(part);
            SapphireActionHandler deleteActionHandler = part.getAction(DELETE_ACTION_ID).getFirstActiveHandler();
            deleteActionHandler.execute((SapphireRenderingContext)sapphireContext);
        }
    }

    public boolean hasDoneChanges() {
        return this.doneChanges;
    }

    protected void setDoneChanges(boolean doneChanges) {
        this.doneChanges = doneChanges;
    }
}

