/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.DefaultResizeConfiguration;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeConfiguration;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.graphiti.features.NoResizeConfiguration;

public class SapphireResizeShapeFeature
extends DefaultResizeShapeFeature {
    public SapphireResizeShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart) {
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            return nodePart.canResizeShape();
        }
        return super.canResizeShape(context);
    }

    public void resizeShape(IResizeShapeContext context) {
        super.resizeShape(context);
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart) {
            int x = context.getX();
            int y = context.getY();
            int width = context.getWidth();
            int height = context.getHeight();
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            nodePart.setNodeBounds(x, y, width, height);
        }
    }

    public IResizeConfiguration getResizeConfiguration(IResizeShapeContext context) {
        if (!this.canResizeShape(context)) {
            return new NoResizeConfiguration();
        }
        return new DefaultResizeConfiguration();
    }
}

