/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;

public class SapphireUpdateNodeFeature
extends AbstractUpdateFeature {
    private static final String LABEL_REASON = "Label is out of date";
    private static final String IMAGE_REASON = "Icon is out of date";

    public SapphireUpdateNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof DiagramNodePart;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        String pictogramName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        ContainerShape cs = null;
        if (pictogramElement instanceof ContainerShape) {
            cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                pictogramName = text.getValue();
                break;
            }
        }
        String businessName = null;
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        DiagramNodePart nodePart = (DiagramNodePart)bo;
        businessName = nodePart.getLabel();
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)LABEL_REASON);
        }
        String newImageId = nodePart.getImageId();
        String oldImageId = Graphiti.getPeService().getPropertyValue((PropertyContainer)cs, "nodeImageId");
        if (newImageId != null && oldImageId != null && !newImageId.equals(oldImageId)) {
            return Reason.createTrueReason((String)IMAGE_REASON);
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        String businessName = null;
        String newImageId = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof DiagramNodePart) {
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            businessName = nodePart.getLabel();
            newImageId = nodePart.getImageId();
        }
        boolean updated = false;
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                Image oldImage;
                if (shape.getGraphicsAlgorithm() instanceof Text) {
                    Text text = (Text)shape.getGraphicsAlgorithm();
                    text.setValue(businessName);
                    updated = true;
                    continue;
                }
                if (!(shape.getGraphicsAlgorithm() instanceof Image) || (oldImage = (Image)shape.getGraphicsAlgorithm()).getId().equals(newImageId)) continue;
                int x = oldImage.getX();
                int y = oldImage.getY();
                int width = oldImage.getWidth();
                int height = oldImage.getHeight();
                Image image = Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)shape, newImageId);
                Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)image, x, y, width, height);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)cs, "nodeImageId", newImageId);
                updated = true;
            }
        }
        return updated;
    }
}

