/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SapphireComposite
extends SapphirePartContainer {
    public ISapphireCompositeDef getDefinition() {
        return (ISapphireCompositeDef)super.getDefinition();
    }

    public final void render(final SapphireRenderingContext context) {
        ScrolledComposite scrolledComposite;
        SapphireRenderingContext ctxt;
        Composite parent = context.getComposite();
        if (this.getPreferFormStyle()) {
            final FormToolkit toolkit = new FormToolkit(context.getDisplay());
            ctxt = new SapphireRenderingContext(this, context, parent){

                public void adapt(Control control) {
                    super.adapt(control);
                    if (control instanceof Composite) {
                        toolkit.adapt((Composite)control);
                    } else if (control instanceof Label) {
                        toolkit.adapt(control, false, false);
                    } else {
                        toolkit.adapt(control, true, true);
                    }
                }
            };
        } else {
            ctxt = context;
        }
        parent = this.createOuterComposite(ctxt);
        ISapphireCompositeDef def = (ISapphireCompositeDef)this.definition;
        boolean indent = (Boolean)def.getIndent().getContent();
        boolean scrollVertically = (Boolean)def.getScrollVertically().getContent();
        boolean scrollHorizontally = (Boolean)def.getScrollHorizontally().getContent();
        if (indent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)GridLayoutUtil.gd());
            context.adapt((Control)label);
        }
        if (scrollVertically || scrollHorizontally) {
            int style = (scrollVertically ? 512 : 0) | (scrollHorizontally ? 256 : 0);
            scrolledComposite = new ScrolledComposite(parent, style);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            parent = scrolledComposite;
        } else {
            scrolledComposite = null;
        }
        boolean scaleVertically = (Boolean)def.getScaleVertically().getContent();
        int width = this.getWidth(-1);
        int height = this.getHeight(-1);
        GridData gd = GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdhspan(scaleVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), indent ? 1 : 2), height), width);
        int marginLeft = (Integer)def.getMarginLeft().getContent();
        int marginRight = (Integer)def.getMarginRight().getContent();
        int marginTop = (Integer)def.getMarginTop().getContent();
        int marginBottom = (Integer)def.getMarginBottom().getContent();
        final Composite composite = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (this.getChildren().length == 0) {
                    return new Point(0, 0);
                }
                return super.computeSize(wHint, hHint, changed);
            }
        };
        composite.setLayout((Layout)GridLayoutUtil.glayout(2, marginLeft, marginRight, marginTop, marginBottom));
        ctxt.adapt((Control)composite);
        if (scrolledComposite != null) {
            scrolledComposite.setContent((Control)composite);
            scrolledComposite.setLayoutData((Object)gd);
        } else {
            composite.setLayoutData((Object)gd);
        }
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)composite, docdef);
            }
        }
        final SapphireRenderingContext innerContext = new SapphireRenderingContext(this, ctxt, composite);
        super.render(innerContext);
        if (scrolledComposite != null) {
            scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        }
        final SapphirePartListener partListener = new SapphirePartListener(){

            public void handleStructureChangedEvent(SapphirePartEvent event) {
                ISapphirePart part = event.getPart();
                Boolean needToReRender = null;
                while (part != null && needToReRender == null) {
                    if (!((part = part.getParentPart()) instanceof SapphireComposite)) continue;
                    needToReRender = part == SapphireComposite.this ? Boolean.TRUE : Boolean.FALSE;
                }
                if (needToReRender == Boolean.TRUE) {
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    SapphireComposite.super.render(innerContext);
                    if (scrolledComposite != null) {
                        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
                    }
                    context.layout();
                }
            }
        };
        this.addListener(partListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphireComposite.this.removeListener(partListener);
            }
        });
    }

    protected Composite createOuterComposite(SapphireRenderingContext context) {
        return context.getComposite();
    }

    public int getWidth(int defaultValue) {
        Integer width = (Integer)this.getDefinition().getWidth().getContent();
        return width == null || width < 1 ? defaultValue : width;
    }

    public int getHeight(int defaultValue) {
        Integer height = (Integer)this.getDefinition().getHeight().getContent();
        return height == null || height < 1 ? defaultValue : height;
    }

    public boolean getPreferFormStyle() {
        return this.definition.getHint("prefer.form.style", false);
    }
}

